/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.bytecode;

import com.oracle.svm.espresso.classfile.bytecode.VolatileArrayAccess;

public final class Bytes {
    public static int beS1(byte[] data, int bci) {
        return data[bci];
    }

    public static int beS2(byte[] data, int bci) {
        return data[bci] << 8 | data[bci + 1] & 0xFF;
    }

    public static int beU1(byte[] data, int bci) {
        return data[bci] & 0xFF;
    }

    public static int volatileBeU1(byte[] data, int bci) {
        return VolatileArrayAccess.volatileRead(data, bci) & 0xFF;
    }

    public static int beU2(byte[] data, int bci) {
        return (data[bci] & 0xFF) << 8 | data[bci + 1] & 0xFF;
    }

    public static int beS4(byte[] data, int bci) {
        return data[bci] << 24 | (data[bci + 1] & 0xFF) << 16 | (data[bci + 2] & 0xFF) << 8 | data[bci + 3] & 0xFF;
    }

    public static void beS4(byte[] data, int bci, int value) {
        data[bci] = (byte)(value >> 24 & 0xFF);
        data[bci + 1] = (byte)(value >> 16 & 0xFF);
        data[bci + 2] = (byte)(value >> 8 & 0xFF);
        data[bci + 3] = (byte)(value & 0xFF);
    }

    public static int beSVar(byte[] data, int bci, boolean fourByte) {
        if (fourByte) {
            return Bytes.beS4(data, bci);
        }
        return Bytes.beS2(data, bci);
    }
}

