/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.descriptors;

import com.oracle.svm.espresso.classfile.descriptors.ByteSequence;
import com.oracle.svm.espresso.classfile.descriptors.ErrorUtil;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.Signature;
import com.oracle.svm.espresso.classfile.descriptors.SignatureSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Symbols;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.classfile.descriptors.Validation;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.collections.EconomicMap;

public final class StaticSymbols {
    private boolean frozen = false;
    private final EconomicMap<ByteSequence, Symbol<?>> symbols;

    public StaticSymbols(StaticSymbols seed, int initialCapacity) {
        this.symbols = EconomicMap.create((int)initialCapacity);
        this.symbols.putAll(seed.symbols);
    }

    public StaticSymbols(int initialCapacity) {
        this.symbols = EconomicMap.create((int)initialCapacity);
    }

    public Symbol<Name> putName(String nameString) {
        ErrorUtil.guarantee(!nameString.isEmpty(), "empty name");
        ByteSequence byteSequence = ByteSequence.create(nameString);
        return this.getOrCreateSymbol(byteSequence);
    }

    public Symbol<Type> putType(String internalName) {
        ByteSequence byteSequence = ByteSequence.create(internalName);
        ErrorUtil.guarantee(Validation.validTypeDescriptor(byteSequence, true), "invalid type");
        return this.getOrCreateSymbol(byteSequence);
    }

    @SafeVarargs
    public final Symbol<Signature> putSignature(Symbol<Type> returnType, Symbol<Type> ... parameterTypes) {
        ByteSequence signatureBytes = SignatureSymbols.createSignature(returnType, parameterTypes);
        ErrorUtil.guarantee(Validation.validSignatureDescriptor(signatureBytes), "invalid signature");
        return this.getOrCreateSymbol(signatureBytes);
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public Set<Symbol<?>> freeze() {
        this.frozen = true;
        HashSet result = new HashSet(this.symbols.size());
        this.symbols.getValues().forEach(result::add);
        return result;
    }

    private <T> Symbol<T> getOrCreateSymbol(ByteSequence byteSequence) {
        Symbol symbol = (Symbol)this.symbols.get((Object)byteSequence);
        if (symbol != null) {
            return symbol;
        }
        ErrorUtil.guarantee(!this.isFrozen(), "static symbols are frozen");
        symbol = Symbols.createSymbolInstanceUnsafe(byteSequence);
        this.symbols.put(symbol, symbol);
        return symbol;
    }
}

