/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.descriptors;

import com.oracle.svm.espresso.classfile.JavaKind;
import com.oracle.svm.espresso.classfile.ParserException;
import com.oracle.svm.espresso.classfile.descriptors.ByteSequence;
import com.oracle.svm.espresso.classfile.descriptors.Descriptor;
import com.oracle.svm.espresso.classfile.descriptors.ErrorUtil;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Symbols;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.classfile.descriptors.Validation;
import java.util.Arrays;

public final class TypeSymbols {
    private final Symbols symbols;

    public TypeSymbols(Symbols symbols) {
        this.symbols = symbols;
    }

    public Symbol<Type> getOrCreateValidType(String typeString) {
        return this.getOrCreateValidType(ByteSequence.create(typeString));
    }

    public Symbol<Type> getOrCreateValidType(ByteSequence typeBytes) {
        return this.getOrCreateValidType(typeBytes, false);
    }

    public Symbol<Type> getOrCreateValidType(ByteSequence typeBytes, boolean ensureStrongReference) {
        if (Validation.validTypeDescriptor(typeBytes, true)) {
            return this.symbols.getOrCreate(typeBytes, ensureStrongReference);
        }
        return null;
    }

    public Symbol<Type> lookupValidType(String typeString) {
        ByteSequence byteSequence = ByteSequence.create(typeString);
        return this.lookupValidType(byteSequence);
    }

    public Symbol<Type> lookupValidType(ByteSequence typeBytes) {
        if (Validation.validTypeDescriptor(typeBytes, true)) {
            return this.symbols.lookup(typeBytes);
        }
        return null;
    }

    public static String internalFromClassName(String className) {
        if (className.startsWith("[") || className.endsWith(";")) {
            return className.replace('.', '/');
        }
        switch (className) {
            case "boolean": {
                return "" + JavaKind.Boolean.getTypeChar();
            }
            case "byte": {
                return "" + JavaKind.Byte.getTypeChar();
            }
            case "char": {
                return "" + JavaKind.Char.getTypeChar();
            }
            case "short": {
                return "" + JavaKind.Short.getTypeChar();
            }
            case "int": {
                return "" + JavaKind.Int.getTypeChar();
            }
            case "float": {
                return "" + JavaKind.Float.getTypeChar();
            }
            case "double": {
                return "" + JavaKind.Double.getTypeChar();
            }
            case "long": {
                return "" + JavaKind.Long.getTypeChar();
            }
            case "void": {
                return "" + JavaKind.Void.getTypeChar();
            }
        }
        return "L" + className.replace('.', '/') + ";";
    }

    public static ByteSequence hiddenClassName(Symbol<Type> type, long id) {
        ByteSequence name = TypeSymbols.typeToName(type);
        int idSize = ByteSequence.positiveLongStringSize(id);
        int length = type.length() - 2 + 1 + idSize;
        byte[] newBytes = new byte[length];
        name.writeTo(newBytes, 0);
        int sepIndex = name.length();
        newBytes[sepIndex] = 43;
        ByteSequence.writePositiveLongString(id, newBytes, sepIndex + 1, idSize);
        ByteSequence result = ByteSequence.wrap(newBytes, 0, length);
        assert (Validation.validModifiedUTF8(result)) : String.format("Not valid anymore: %s + %d -> %s", type.toHexString(), id, result.toHexString());
        return result;
    }

    public static ByteSequence typeToName(Symbol<Type> type) {
        assert (type.byteAt(0) == 76);
        assert (type.byteAt(type.length() - 1) == 59);
        return type.subSequence(1, type.length() - 1);
    }

    public Symbol<Type> fromDescriptorString(String desc) {
        JavaKind kind = JavaKind.fromTypeString(desc);
        if (kind.isPrimitive()) {
            return TypeSymbols.forPrimitive(kind);
        }
        return this.fromClassGetName(desc);
    }

    public Symbol<Type> fromClassGetName(String className) {
        String internalName = TypeSymbols.internalFromClassName(className);
        ByteSequence byteSequence = ByteSequence.create(internalName);
        ErrorUtil.guarantee(Validation.validTypeDescriptor(byteSequence, true), "invalid type");
        return this.symbols.getOrCreate(byteSequence);
    }

    public static Symbol<Type> forPrimitive(JavaKind kind) {
        assert (kind.isPrimitive());
        return kind.getType();
    }

    Symbol<Type> parse(Symbol<? extends Descriptor> descriptor, int beginIndex, boolean slashes) throws ParserException.ClassFormatError {
        int endIndex = TypeSymbols.skipValidTypeDescriptor(descriptor, beginIndex, slashes);
        if (endIndex == beginIndex + 1) {
            try {
                return TypeSymbols.forPrimitive(JavaKind.fromPrimitiveOrVoidTypeChar((char)descriptor.byteAt(beginIndex)));
            }
            catch (IllegalStateException e) {
                throw new ParserException.ClassFormatError("invalid descriptor: " + String.valueOf(descriptor));
            }
        }
        return this.symbols.getOrCreate(descriptor.subSequence(beginIndex, endIndex));
    }

    static int skipValidTypeDescriptor(Symbol<? extends Descriptor> descriptor, int beginIndex, boolean slashes) throws ParserException.ClassFormatError {
        if (beginIndex >= descriptor.length()) {
            throw new ParserException.ClassFormatError("invalid type descriptor: " + String.valueOf(descriptor));
        }
        char ch = (char)descriptor.byteAt(beginIndex);
        if (ch != '[' && ch != 'L') {
            return beginIndex + 1;
        }
        switch (ch) {
            case 'L': {
                int endIndex = TypeSymbols.skipClassName(descriptor, beginIndex + 1, slashes ? (char)'/' : '.');
                if (endIndex > beginIndex + 1 && endIndex < descriptor.length() && descriptor.byteAt(endIndex) == 59) {
                    return endIndex + 1;
                }
                throw new ParserException.ClassFormatError("Invalid Java name " + String.valueOf(descriptor.subSequence(beginIndex)));
            }
            case '[': {
                int index;
                for (index = beginIndex; index < descriptor.length() && descriptor.byteAt(index) == 91; ++index) {
                }
                int dimensions = index - beginIndex;
                if (dimensions > 255) {
                    throw new ParserException.ClassFormatError("Array with more than 255 dimensions " + String.valueOf(descriptor.subSequence(beginIndex)));
                }
                return TypeSymbols.skipValidTypeDescriptor(descriptor, index, slashes);
            }
        }
        throw new ParserException.ClassFormatError("Invalid type descriptor " + String.valueOf(descriptor.subSequence(beginIndex)));
    }

    public Symbol<Type> arrayOf(Symbol<Type> type, int dimensions) {
        assert (dimensions > 0);
        if (TypeSymbols.getArrayDimensions(type) + dimensions > 255) {
            throw new ParserException.ClassFormatError("Array type with more than 255 dimensions");
        }
        byte[] bytes = new byte[type.length() + dimensions];
        Arrays.fill(bytes, 0, dimensions, (byte)91);
        type.writeTo(bytes, dimensions);
        return this.symbols.getOrCreate(ByteSequence.wrap(bytes));
    }

    public Symbol<Type> arrayOf(Symbol<Type> type) {
        return this.arrayOf(type, 1);
    }

    private static int skipClassName(Symbol<? extends Descriptor> descriptor, int from, char separator) throws ParserException.ClassFormatError {
        int index;
        assert (separator == '.' || separator == '/');
        int length = descriptor.length();
        for (index = from; index < length; ++index) {
            char ch = (char)descriptor.byteAt(index);
            if (!(ch == '.' || ch == '/' ? separator != ch : ch == ';' || ch == '[')) continue;
            return index;
        }
        return index;
    }

    public static boolean isReference(ByteSequence type) {
        return type.length() > 1;
    }

    public static boolean isPrimitive(ByteSequence type) {
        if (type.length() != 1) {
            return false;
        }
        switch (type.byteAt(0)) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 86: 
            case 90: {
                return true;
            }
        }
        return false;
    }

    public static JavaKind getJavaKind(Symbol<Type> type) {
        if (type.length() == 1) {
            return JavaKind.fromPrimitiveOrVoidTypeChar((char)type.byteAt(0));
        }
        return JavaKind.Object;
    }

    public static int getArrayDimensions(ByteSequence type) {
        int dims;
        for (dims = 0; dims < type.length() && type.byteAt(dims) == 91; ++dims) {
        }
        return dims;
    }

    public static boolean isArray(Symbol<Type> type) {
        assert (type.length() > 0) : "empty symbol";
        return type.length() > 0 && type.byteAt(0) == 91;
    }

    public Symbol<Type> getComponentType(Symbol<Type> type) {
        if (TypeSymbols.isArray(type)) {
            return this.symbols.getOrCreate(type.subSequence(1));
        }
        return null;
    }

    public Symbol<Type> getElementalType(Symbol<Type> type) {
        if (TypeSymbols.isArray(type)) {
            return this.symbols.getOrCreate(type.subSequence(TypeSymbols.getArrayDimensions(type)));
        }
        return type;
    }

    public Symbol<Type> fromClass(Class<?> clazz) {
        ByteSequence descriptor = ByteSequence.create(TypeSymbols.internalFromClassName(clazz.getName()));
        assert (Validation.validTypeDescriptor(descriptor, true)) : descriptor;
        return this.symbols.getOrCreate(descriptor);
    }

    public static String binaryName(Symbol<Type> type) {
        if (TypeSymbols.isArray(type)) {
            return type.toString().replace('/', '.');
        }
        if (TypeSymbols.isPrimitive(type)) {
            return TypeSymbols.getJavaKind(type).getJavaName();
        }
        return type.subSequence(1, type.length() - 1).toString().replace('/', '.');
    }

    public static Symbol<Type> fromSymbol(Symbol<?> symbol) {
        ErrorUtil.guarantee(Validation.validTypeDescriptor(symbol, true), "invalid type");
        return symbol;
    }

    public static Symbol<Type> fromSymbolUnsafe(Symbol<?> symbol) {
        assert (Validation.validTypeDescriptor(symbol, true)) : symbol;
        return symbol;
    }

    public static Symbol<Type> fromDescriptorUnsafe(Symbol<? extends Descriptor> descriptor) {
        assert (Validation.validTypeDescriptor(descriptor, true)) : descriptor;
        return descriptor;
    }

    public Symbol<Type> fromClassNameEntry(Symbol<Name> name) {
        ErrorUtil.guarantee(Validation.validClassNameEntry(name), "invalid class name entry");
        if (name.byteAt(0) == 91) {
            return TypeSymbols.fromSymbol(name);
        }
        return this.symbols.getOrCreate(TypeSymbols.nameToType(name));
    }

    public Symbol<Type> fromClassNameEntryUnsafe(Symbol<Name> name) {
        assert (Validation.validClassNameEntry(name)) : name;
        if (name.byteAt(0) == 91) {
            return TypeSymbols.fromSymbolUnsafe(name);
        }
        return this.symbols.getOrCreate(TypeSymbols.nameToType(name));
    }

    public static ByteSequence nameToType(ByteSequence name) {
        if (name.byteAt(0) == 91) {
            assert (Validation.validTypeDescriptor(name, true)) : "Type validity should have been checked beforehand: " + String.valueOf(name);
            return name;
        }
        byte[] bytes = new byte[name.length() + 2];
        name.writeTo(bytes, 1);
        bytes[0] = 76;
        bytes[bytes.length - 1] = 59;
        ByteSequence wrap = ByteSequence.wrap(bytes);
        assert (Validation.validTypeDescriptor(wrap, true)) : wrap;
        return wrap;
    }

    public static ByteSequence getRuntimePackage(ByteSequence symbol) {
        if (symbol.byteAt(0) == 91) {
            int arrayDimensions = TypeSymbols.getArrayDimensions(symbol);
            return TypeSymbols.getRuntimePackage(symbol.subSequence(arrayDimensions));
        }
        if (symbol.byteAt(0) != 76) {
            assert (TypeSymbols.isPrimitive(symbol));
            return ByteSequence.EMPTY;
        }
        int lastSlash = symbol.lastIndexOf((byte)47);
        if (lastSlash < 0) {
            return ByteSequence.EMPTY;
        }
        return symbol.subSequence(1, lastSlash);
    }

    public static int slotCount(Symbol<Type> type) {
        switch (type.byteAt(0)) {
            case 86: {
                return 0;
            }
            case 68: 
            case 74: {
                return 2;
            }
        }
        return 1;
    }
}

