/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.perf;

import com.oracle.svm.espresso.classfile.descriptors.ErrorUtil;
import com.oracle.svm.espresso.classfile.perf.DebugCloseable;
import com.oracle.svm.espresso.classfile.perf.TimerCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class DebugTimer {
    final String name;
    private List<DebugTimer> children = null;
    private final DebugTimer parent;

    private DebugTimer(String name, DebugTimer parent) {
        this.name = name;
        this.parent = parent;
    }

    public static DebugTimer create(String name) {
        return DebugTimer.create(name, null);
    }

    public static DebugTimer create(String name, DebugTimer parent) {
        DebugTimer timer = new DebugTimer(name, parent);
        if (parent != null) {
            parent.registerChild(timer);
        }
        return timer;
    }

    public DebugCloseable scope(TimerCollection timers) {
        return timers.scope(this);
    }

    static DebugTimerImpl spawn() {
        return new Default();
    }

    private void registerChild(DebugTimer child) {
        if (this.children == null) {
            this.children = new ArrayList<DebugTimer>();
        }
        this.children.add(child);
    }

    List<DebugTimer> children() {
        return this.children;
    }

    DebugTimer parent() {
        return this.parent;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DebugTimer && ((DebugTimer)obj).name.equals(this.name);
    }

    private static final class Default
    extends DebugTimerImpl {
        private final AtomicLong clock = new AtomicLong();
        private final AtomicLong counter = new AtomicLong();
        private final ThreadLocal<Boolean> entered = ThreadLocal.withInitial(new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return false;
            }
        });

        private Default() {
        }

        @Override
        void tick(long tick) {
            ErrorUtil.guarantee(this.entered.get(), "Not entered scope.");
            this.counter.getAndIncrement();
            this.clock.getAndAdd(tick);
            this.entered.set(false);
        }

        @Override
        void report(Consumer<String> logger, String name) {
            if (this.counter.get() == 0L) {
                logger.accept(name + ": 0");
            } else {
                logger.accept(name + " total : " + Default.getAsMillis(this.total()) + " | avg : " + Default.getAsMillis(this.avg()));
            }
        }

        @Override
        void enter() {
            ErrorUtil.guarantee(this.entered.get() == false, "Counting twice for timer.");
            this.entered.set(true);
        }

        private long total() {
            return this.clock.get();
        }

        private long avg() {
            return this.counter.get() == 0L ? 0L : this.total() / this.counter.get();
        }

        private static double getAsMillis(long value) {
            return (double)(value / 1000L) / 1000.0;
        }
    }

    static abstract class AutoTimer
    implements DebugCloseable {
        static final AutoTimer NO_TIMER = new NoTimer();

        private AutoTimer() {
        }

        static DebugCloseable scope(DebugTimerImpl impl) {
            return new Default(impl);
        }

        @Override
        public abstract void close();

        private static final class Default
        extends AutoTimer {
            private final DebugTimerImpl timer;
            private final long tick;

            private Default(DebugTimerImpl timer) {
                this.timer = timer;
                this.tick = System.nanoTime();
            }

            @Override
            public void close() {
                this.timer.tick(System.nanoTime() - this.tick);
            }
        }

        private static final class NoTimer
        extends AutoTimer {
            private NoTimer() {
            }

            @Override
            public void close() {
            }
        }
    }

    static abstract class DebugTimerImpl {
        DebugTimerImpl() {
        }

        abstract void tick(long var1);

        abstract void report(Consumer<String> var1, String var2);

        abstract void enter();
    }
}

