/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.tracing.core;

import com.oracle.svm.core.jni.headers.JNIMethodId;
import java.util.Arrays;
import org.graalvm.collections.EconomicMap;

public abstract class Tracer {
    public static final String EXPLICIT_NULL = new String("null");
    public static final String UNKNOWN_VALUE = new String("\u0000");

    protected static Object handleSpecialValue(Object obj) {
        if (obj == EXPLICIT_NULL) {
            return null;
        }
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            Object[] newArray = null;
            for (int i = 0; i < array.length; ++i) {
                Object newValue = Tracer.handleSpecialValue(array[i]);
                if (newValue == array[i]) continue;
                if (newArray == null) {
                    newArray = Arrays.copyOf(array, array.length);
                }
                newArray[i] = newValue;
            }
            return newArray != null ? newArray : array;
        }
        return obj;
    }

    public void traceInitialization() {
        EconomicMap entry = EconomicMap.create();
        entry.put((Object)"tracer", (Object)"meta");
        entry.put((Object)"event", (Object)"initialization");
        entry.put((Object)"version", (Object)"1");
        this.traceEntry((EconomicMap<String, Object>)entry);
    }

    public void tracePhaseChange(String phase) {
        EconomicMap entry = EconomicMap.create();
        entry.put((Object)"tracer", (Object)"meta");
        entry.put((Object)"event", (Object)"phase_change");
        entry.put((Object)"phase", (Object)phase);
        this.traceEntry((EconomicMap<String, Object>)entry);
    }

    public void traceTrackReflectionMetadata(boolean trackReflectionMetadata) {
        EconomicMap entry = EconomicMap.create();
        entry.put((Object)"tracer", (Object)"meta");
        entry.put((Object)"event", (Object)"track_reflection_metadata");
        entry.put((Object)"track", (Object)trackReflectionMetadata);
        this.traceEntry((EconomicMap<String, Object>)entry);
    }

    public void traceCall(String tracer, String function, Object clazz, Object declaringClass, Object callerClass, Object result, JNIMethodId[] stackTrace, Object ... args) {
        EconomicMap entry = EconomicMap.create();
        entry.put((Object)"tracer", (Object)tracer);
        entry.put((Object)"function", (Object)function);
        if (clazz != null) {
            entry.put((Object)"class", Tracer.handleSpecialValue(clazz));
        }
        if (declaringClass != null) {
            entry.put((Object)"declaring_class", Tracer.handleSpecialValue(declaringClass));
        }
        if (callerClass != null) {
            entry.put((Object)"caller_class", Tracer.handleSpecialValue(callerClass));
        }
        if (result != null) {
            entry.put((Object)"result", Tracer.handleSpecialValue(result));
        }
        if (args != null) {
            entry.put((Object)"args", Tracer.handleSpecialValue(args));
        }
        if (stackTrace != null) {
            entry.put((Object)"stack_trace", (Object)stackTrace);
        }
        this.traceEntry((EconomicMap<String, Object>)entry);
    }

    protected abstract void traceEntry(EconomicMap<String, Object> var1);
}

