/*
 * Copyright (c) 2016, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.graal.compiler.core.common;

/**
 * A compact representation of the different encoding strategies for Objects and metadata.
 */
public final class CompressEncoding {
    private final long base;
    private final int shift;

    public CompressEncoding(long base, int shift) {
        this.base = base;
        this.shift = shift;
    }

    public boolean hasBase() {
        return base != 0;
    }

    public boolean hasShift() {
        return shift != 0;
    }

    public long getBase() {
        return base;
    }

    public int getShift() {
        return shift;
    }

    @Override
    public String toString() {
        return "base: " + base + " shift: " + shift;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + (int) (base ^ (base >>> 32));
        result = prime * result + shift;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CompressEncoding) {
            CompressEncoding other = (CompressEncoding) obj;
            return base == other.base && shift == other.shift;
        }
        return false;
    }
}
