// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: SubstrateOptions.ConcealedOptions.java
package com.oracle.svm.core;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class SubstrateOptions_ConcealedOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(SubstrateOptions.ConcealedOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "AllocatePrefetchStyle": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchStyle",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Generated code style for prefetch instructions: for 0 or less no prefetch instructions are generated and for 1 or more prefetch instructions are introduced after each allocation.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ConcealedOptions.AllocatePrefetchStyle,
                /*fieldName*/ "AllocatePrefetchStyle",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AutomaticReferenceHandling": {
            return OptionDescriptor.create(
                /*name*/ "AutomaticReferenceHandling",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if the reference handling is executed automatically or manually.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ConcealedOptions.AutomaticReferenceHandling,
                /*fieldName*/ "AutomaticReferenceHandling",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CodeAlignment": {
            return OptionDescriptor.create(
                /*name*/ "CodeAlignment",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Alignment of AOT and JIT compiled code in bytes. The default of 0 automatically selects a suitable value.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ConcealedOptions.CodeAlignment,
                /*fieldName*/ "CodeAlignment",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CompileInIsolates": {
            return OptionDescriptor.create(
                /*name*/ "CompileInIsolates",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Activate runtime compilation in separate isolates (enable support during image build with option SupportCompileInIsolates).",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ConcealedOptions.CompileInIsolates,
                /*fieldName*/ "CompileInIsolates",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DumpRuntimeCompiledMethods": {
            return OptionDescriptor.create(
                /*name*/ "DumpRuntimeCompiledMethods",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Dump the instructions of runtime compiled methods in temporary files.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ConcealedOptions.DumpRuntimeCompiledMethods,
                /*fieldName*/ "DumpRuntimeCompiledMethods",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxJavaStackTraceDepth": {
            return OptionDescriptor.create(
                /*name*/ "MaxJavaStackTraceDepth",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of lines in the stack trace for Java exceptions (0 means all)",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ConcealedOptions.MaxJavaStackTraceDepth,
                /*fieldName*/ "MaxJavaStackTraceDepth",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxRAM": {
            return OptionDescriptor.create(
                /*name*/ "MaxRAM",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Long.class,
                /*help*/ "Physical memory size (in bytes). By default, the value is queried from the OS/container during VM startup.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ConcealedOptions.MaxRAM,
                /*fieldName*/ "MaxRAM",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PageSize": {
            return OptionDescriptor.create(
                /*name*/ "PageSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The largest page size of machines that can run the image. The default of 0 automatically selects a typically suitable value.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ConcealedOptions.PageSize,
                /*fieldName*/ "PageSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Path": {
            return OptionDescriptor.create(
                /*name*/ "Path",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Directory of the image file to be generated",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ConcealedOptions.Path,
                /*fieldName*/ "Path",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SupportCompileInIsolates": {
            return OptionDescriptor.create(
                /*name*/ "SupportCompileInIsolates",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Support runtime compilation in separate isolates (enable at runtime with option CompileInIsolates).",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ConcealedOptions.SupportCompileInIsolates,
                /*fieldName*/ "SupportCompileInIsolates",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseDedicatedVMOperationThread": {
            return OptionDescriptor.create(
                /*name*/ "UseDedicatedVMOperationThread",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if VM operations should be executed in a dedicated thread.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ConcealedOptions.UseDedicatedVMOperationThread,
                /*fieldName*/ "UseDedicatedVMOperationThread",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UsePerfData": {
            return OptionDescriptor.create(
                /*name*/ "UsePerfData",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Flag to disable jvmstat instrumentation for performance testing.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ConcealedOptions.UsePerfData,
                /*fieldName*/ "UsePerfData",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 12;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AllocatePrefetchStyle");
                    case 1: return get("AutomaticReferenceHandling");
                    case 2: return get("CodeAlignment");
                    case 3: return get("CompileInIsolates");
                    case 4: return get("DumpRuntimeCompiledMethods");
                    case 5: return get("MaxJavaStackTraceDepth");
                    case 6: return get("MaxRAM");
                    case 7: return get("PageSize");
                    case 8: return get("Path");
                    case 9: return get("SupportCompileInIsolates");
                    case 10: return get("UseDedicatedVMOperationThread");
                    case 11: return get("UsePerfData");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
