// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: VMInspectionOptions.java
package com.oracle.svm.core;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class VMInspectionOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(VMInspectionOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "DumpRuntimeCompilationOnSignal": {
            return OptionDescriptor.create(
                /*name*/ "DumpRuntimeCompilationOnSignal",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Dumps all runtime compiled methods on SIGUSR2.",
                /*container*/ getContainer(),
                /*option*/ VMInspectionOptions.DumpRuntimeCompilationOnSignal,
                /*fieldName*/ "DumpRuntimeCompilationOnSignal",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EnableMonitoringFeatures": {
            return OptionDescriptor.create(
                /*name*/ "EnableMonitoringFeatures",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Enable monitoring features that allow the VM to be inspected at run time. Comma-separated list can contain 'heapdump', 'jfr', 'jvmstat', 'jmxserver' (experimental), 'jmxclient' (experimental), 'threaddump', 'nmt' (experimental), 'jcmd' (experimental), or 'all' (deprecated behavior: defaults to 'all' if no argument is provided). For example: '--enable-monitoring=heapdump,jfr'.",
                /*container*/ getContainer(),
                /*option*/ VMInspectionOptions.EnableMonitoringFeatures,
                /*fieldName*/ "EnableMonitoringFeatures",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintNMTStatistics": {
            return OptionDescriptor.create(
                /*name*/ "PrintNMTStatistics",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print native memory tracking statistics on shutdown if native memory tracking is enabled.",
                /*container*/ getContainer(),
                /*option*/ VMInspectionOptions.PrintNMTStatistics,
                /*fieldName*/ "PrintNMTStatistics",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 3;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("DumpRuntimeCompilationOnSignal");
                    case 1: return get("EnableMonitoringFeatures");
                    case 2: return get("PrintNMTStatistics");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
