// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: InterpreterOptions.java
package com.oracle.svm.interpreter;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class InterpreterOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(InterpreterOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "DebuggerWithInterpreter": {
            return OptionDescriptor.create(
                /*name*/ "DebuggerWithInterpreter",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Adds support to divert execution from AOT compiled methods to the interpreter at run-time.",
                /*container*/ getContainer(),
                /*option*/ InterpreterOptions.DebuggerWithInterpreter,
                /*fieldName*/ "DebuggerWithInterpreter",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InterpreterBuildTimeLogging": {
            return OptionDescriptor.create(
                /*name*/ "InterpreterBuildTimeLogging",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables logging at build time related to the interpreter setup",
                /*container*/ getContainer(),
                /*option*/ InterpreterOptions.InterpreterBuildTimeLogging,
                /*fieldName*/ "InterpreterBuildTimeLogging",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InterpreterDumpClassFiles": {
            return OptionDescriptor.create(
                /*name*/ "InterpreterDumpClassFiles",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ String.class,
                /*help*/ "Path to dump interpreter universe metadata as .class files",
                /*container*/ getContainer(),
                /*option*/ InterpreterOptions.InterpreterDumpClassFiles,
                /*fieldName*/ "InterpreterDumpClassFiles",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InterpreterTrace": {
            return OptionDescriptor.create(
                /*name*/ "InterpreterTrace",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace Interpreter execution",
                /*container*/ getContainer(),
                /*option*/ InterpreterOptions.InterpreterTrace,
                /*fieldName*/ "InterpreterTrace",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InterpreterTraceSupport": {
            return OptionDescriptor.create(
                /*name*/ "InterpreterTraceSupport",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Include interpreter tracing code in image",
                /*container*/ getContainer(),
                /*option*/ InterpreterOptions.InterpreterTraceSupport,
                /*fieldName*/ "InterpreterTraceSupport",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 5;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("DebuggerWithInterpreter");
                    case 1: return get("InterpreterBuildTimeLogging");
                    case 2: return get("InterpreterDumpClassFiles");
                    case 3: return get("InterpreterTrace");
                    case 4: return get("InterpreterTraceSupport");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
