/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.CalleeSavedRegisters;
import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CollectingObjectReferenceVisitor;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.FrameInfoVerifier;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.ReferenceMapEncoder;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.util.VMError;
import java.util.BitSet;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackLockValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.VirtualObject;
import jdk.vm.ci.code.site.ExceptionHandler;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

class CodeInfoVerifier {
    private final FrameInfoDecoder.ConstantAccess constantAccess;

    CodeInfoVerifier(FrameInfoDecoder.ConstantAccess constantAccess) {
        this.constantAccess = constantAccess;
    }

    void verifyMethod(SharedMethod method, CompilationResult compilation, int compilationOffset, int compilationSize, CodeInfo info) {
        int offset;
        CodeInfoQueryResult queryResult = new CodeInfoQueryResult();
        for (int relativeIP = 0; relativeIP < compilationSize; ++relativeIP) {
            int totalIP = relativeIP + compilationOffset;
            CodeInfoAccess.lookupCodeInfo(info, totalIP, queryResult, this.constantAccess);
            assert (queryResult.isEntryPoint() == method.isEntryPoint()) : queryResult;
            assert (queryResult.hasCalleeSavedRegisters() == method.hasCalleeSavedRegisters()) : queryResult;
            assert (queryResult.getTotalFrameSize() == (long)compilation.getTotalFrameSize()) : queryResult;
            assert (CodeInfoAccess.lookupStackReferenceMapIndex(info, totalIP) == queryResult.getReferenceMapIndex()) : queryResult;
        }
        for (Infopoint infopoint : compilation.getInfopoints()) {
            if (infopoint.debugInfo == null || (offset = CodeInfoEncoder.getEntryOffset(infopoint)) < 0) continue;
            assert (offset < compilationSize) : infopoint;
            CodeInfoAccess.lookupCodeInfo(info, offset + compilationOffset, queryResult, this.constantAccess);
            Pointer base = (Pointer)Word.pointer((long)0x40000000L);
            CollectingObjectReferenceVisitor visitor = new CollectingObjectReferenceVisitor(base);
            CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)base, CodeInfoAccess.getStackReferenceMapEncoding(info), queryResult.getReferenceMapIndex(), visitor, null);
            ReferenceMapEncoder.Input expected = (ReferenceMapEncoder.Input)infopoint.debugInfo.getReferenceMap();
            visitor.result.verify();
            assert (expected.equals(visitor.result)) : infopoint;
            if (queryResult.frameInfo == CodeInfoQueryResult.NO_FRAME_INFO) continue;
            this.verifyFrame(compilation, infopoint.debugInfo.frame(), queryResult.frameInfo, new BitSet());
        }
        for (ExceptionHandler handler : compilation.getExceptionHandlers()) {
            offset = handler.pcOffset;
            assert (offset >= 0 && offset < compilationSize) : handler;
            CodeInfoAccess.lookupCodeInfo(info, offset + compilationOffset, queryResult, this.constantAccess);
            long actual = queryResult.getExceptionOffset();
            long expected = handler.handlerPos - handler.pcOffset;
            assert (expected != 0L) : handler;
            assert (expected == actual) : handler;
        }
    }

    private void verifyFrame(CompilationResult compilation, BytecodeFrame expectedFrame, FrameInfoQueryResult actualFrame, BitSet visitedVirtualObjects) {
        assert (expectedFrame == null == (actualFrame == null)) : actualFrame;
        if (expectedFrame == null || !actualFrame.hasLocalValueInfo()) {
            return;
        }
        this.verifyFrame(compilation, expectedFrame.caller(), actualFrame.getCaller(), visitedVirtualObjects);
        for (int i = 0; i < expectedFrame.values.length; ++i) {
            JavaValue expectedValue = expectedFrame.values[i];
            if (i >= actualFrame.getValueInfos().length) {
                assert (ValueUtil.isIllegalJavaValue((JavaValue)expectedValue)) : actualFrame;
                continue;
            }
            FrameInfoQueryResult.ValueInfo actualValue = actualFrame.getValueInfos()[i];
            JavaKind expectedKind = FrameInfoEncoder.getFrameValueKind(expectedFrame, i);
            assert (expectedKind == actualValue.getKind()) : actualFrame;
            this.verifyValue(compilation, expectedValue, actualValue, actualFrame, visitedVirtualObjects);
        }
    }

    private void verifyValue(CompilationResult compilation, JavaValue e, FrameInfoQueryResult.ValueInfo actualValue, FrameInfoQueryResult actualFrame, BitSet visitedVirtualObjects) {
        JavaValue expectedValue = e;
        if (expectedValue instanceof StackLockValue) {
            StackLockValue lock = (StackLockValue)expectedValue;
            assert (ValueUtil.isIllegal((Value)lock.getSlot())) : actualValue;
            assert (lock.isEliminated() == actualValue.isEliminatedMonitor()) : actualValue;
            expectedValue = lock.getOwner();
        } else assert (!actualValue.isEliminatedMonitor()) : actualValue;
        if (ValueUtil.isIllegalJavaValue((JavaValue)expectedValue)) {
            assert (actualValue.getType() == FrameInfoQueryResult.ValueType.Illegal) : actualValue;
        } else if (ValueUtil.isConstantJavaValue((JavaValue)expectedValue)) {
            assert (actualValue.getType() == FrameInfoQueryResult.ValueType.Constant || actualValue.getType() == FrameInfoQueryResult.ValueType.DefaultConstant) : actualValue;
            JavaConstant expectedConstant = ValueUtil.asConstantJavaValue((JavaValue)expectedValue);
            JavaConstant actualConstant = actualValue.getValue();
            FrameInfoVerifier.verifyConstant(expectedConstant, actualConstant);
        } else if (expectedValue instanceof StackSlot) {
            assert (actualValue.getType() == FrameInfoQueryResult.ValueType.StackSlot) : actualValue;
            int expectedOffset = ((StackSlot)expectedValue).getOffset(compilation.getTotalFrameSize());
            long actualOffset = actualValue.getData();
            assert ((long)expectedOffset == actualOffset) : actualValue;
        } else if (ReservedRegisters.singleton().isAllowedInFrameState(expectedValue)) {
            assert (actualValue.getType() == FrameInfoQueryResult.ValueType.ReservedRegister) : actualValue;
            int expectedNumber = ValueUtil.asRegister((Value)((RegisterValue)expectedValue)).number;
            long actualNumber = actualValue.getData();
            assert ((long)expectedNumber == actualNumber) : actualValue;
        } else if (CalleeSavedRegisters.supportedByPlatform() && expectedValue instanceof RegisterValue) {
            assert (actualValue.getType() == FrameInfoQueryResult.ValueType.Register) : actualValue;
            int expectedOffset = CalleeSavedRegisters.singleton().getOffsetInFrame(ValueUtil.asRegister((Value)((RegisterValue)expectedValue)));
            long actualOffset = actualValue.getData();
            assert ((long)expectedOffset == actualOffset) : actualValue;
            assert (actualOffset < 0L) : "Registers are stored in callee saved area of callee frame, i.e., with negative offset";
        } else if (ValueUtil.isVirtualObject((JavaValue)expectedValue)) {
            assert (actualValue.getType() == FrameInfoQueryResult.ValueType.VirtualObject) : actualValue;
            int expectedId = ValueUtil.asVirtualObject((JavaValue)expectedValue).getId();
            long actualId = actualValue.getData();
            assert ((long)expectedId == actualId) : actualValue;
            this.verifyVirtualObject(compilation, ValueUtil.asVirtualObject((JavaValue)expectedValue), actualFrame.getVirtualObjects()[expectedId], actualFrame, visitedVirtualObjects);
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput(expectedValue);
        }
    }

    private void verifyVirtualObject(CompilationResult compilation, VirtualObject expectedObject, FrameInfoQueryResult.ValueInfo[] actualObject, FrameInfoQueryResult actualFrame, BitSet visitedVirtualObjects) {
        if (visitedVirtualObjects.get(expectedObject.getId())) {
            return;
        }
        visitedVirtualObjects.set(expectedObject.getId());
        ObjectLayout objectLayout = ConfigurationValues.getObjectLayout();
        SharedType expectedType = (SharedType)expectedObject.getType();
        if (expectedType.isArray()) {
            JavaKind kind = ((SharedType)expectedType.getComponentType()).getStorageKind();
            int expectedLength = 0;
            for (int i = 0; i < expectedObject.getValues().length; ++i) {
                JavaValue expectedValue = expectedObject.getValues()[i];
                UnsignedWord expectedOffset = Word.unsigned((long)objectLayout.getArrayElementOffset(kind, expectedLength));
                FrameInfoQueryResult.ValueInfo actualValue = this.findActualArrayElement(actualObject, expectedOffset);
                this.verifyValue(compilation, expectedValue, actualValue, actualFrame, visitedVirtualObjects);
                JavaKind valueKind = expectedObject.getSlotKind(i);
                if (objectLayout.sizeInBytes(kind) == 4 && objectLayout.sizeInBytes(valueKind) == 8) {
                    expectedLength += 2;
                    continue;
                }
                ++expectedLength;
            }
            int actualLength = actualObject[1].value.asInt();
            assert (expectedLength == actualLength) : actualFrame;
        } else {
            SharedField[] expectedFields = (SharedField[])expectedType.getInstanceFields(true);
            int fieldIdx = 0;
            int valueIdx = 0;
            while (valueIdx < expectedObject.getValues().length) {
                SharedField expectedField = expectedFields[fieldIdx];
                ++fieldIdx;
                JavaValue expectedValue = expectedObject.getValues()[valueIdx];
                JavaKind valueKind = expectedObject.getSlotKind(valueIdx);
                ++valueIdx;
                JavaKind kind = expectedField.getStorageKind();
                if (objectLayout.sizeInBytes(kind) == 4 && objectLayout.sizeInBytes(valueKind) == 8) {
                    ++fieldIdx;
                }
                UnsignedWord expectedOffset = Word.unsigned((int)expectedField.getLocation());
                FrameInfoQueryResult.ValueInfo actualValue = this.findActualField(actualObject, expectedOffset);
                this.verifyValue(compilation, expectedValue, actualValue, actualFrame, visitedVirtualObjects);
            }
        }
    }

    private FrameInfoQueryResult.ValueInfo findActualArrayElement(FrameInfoQueryResult.ValueInfo[] actualObject, UnsignedWord expectedOffset) {
        DynamicHub hub = (DynamicHub)this.constantAccess.asObject(actualObject[0].getValue());
        ObjectLayout objectLayout = ConfigurationValues.getObjectLayout();
        assert (LayoutEncoding.isArray(hub.getLayoutEncoding())) : hub;
        return CodeInfoVerifier.findActualValue(actualObject, expectedOffset, objectLayout, LayoutEncoding.getArrayBaseOffset(hub.getLayoutEncoding()), 2);
    }

    private FrameInfoQueryResult.ValueInfo findActualField(FrameInfoQueryResult.ValueInfo[] actualObject, UnsignedWord expectedOffset) {
        DynamicHub hub = (DynamicHub)this.constantAccess.asObject(actualObject[0].getValue());
        ObjectLayout objectLayout = ConfigurationValues.getObjectLayout();
        assert (LayoutEncoding.isPureInstance(hub.getLayoutEncoding())) : hub;
        return CodeInfoVerifier.findActualValue(actualObject, expectedOffset, objectLayout, Word.unsigned((int)objectLayout.getFirstFieldOffset()), 1);
    }

    private static FrameInfoQueryResult.ValueInfo findActualValue(FrameInfoQueryResult.ValueInfo[] actualObject, UnsignedWord expectedOffset, ObjectLayout objectLayout, UnsignedWord startOffset, int startIdx) {
        UnsignedWord curOffset = startOffset;
        int curIdx = startIdx;
        while (curOffset.belowThan(expectedOffset)) {
            FrameInfoQueryResult.ValueInfo value = actualObject[curIdx];
            curOffset = curOffset.add(objectLayout.sizeInBytes(value.getKind()));
            ++curIdx;
        }
        if (curOffset.equal(expectedOffset)) {
            return actualObject[curIdx];
        }
        FrameInfoQueryResult.ValueInfo illegal = new FrameInfoQueryResult.ValueInfo();
        illegal.type = FrameInfoQueryResult.ValueType.Illegal;
        return illegal;
    }
}

