/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.RuntimeConditionSet;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class ConditionalRuntimeValue<T> {
    RuntimeConditionSet conditions;
    volatile T value;

    public ConditionalRuntimeValue(RuntimeConditionSet conditions, T value) {
        this.conditions = conditions;
        this.value = value;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public T getValueUnconditionally() {
        return this.value;
    }

    public RuntimeConditionSet getConditions() {
        return this.conditions;
    }

    public T getValue() {
        if (this.conditions.satisfied()) {
            return this.value;
        }
        return null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void updateValue(T newValue) {
        this.value = newValue;
    }
}

