/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.IsolateArgumentParser;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.SerialAndEpsilonGCOptions;
import com.oracle.svm.core.genscavenge.TlabSupport;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.option.RuntimeOptionValidationSupport;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class TlabOptionCache {
    private long minTlabSize = TlabOptionCache.getAbsoluteMinTlabSize();
    private long tlabSize = SubstrateGCOptions.TlabOptions.TLABSize.getHostedValue();
    private long initialTLABSize = SerialAndEpsilonGCOptions.InitialTLABSize.getHostedValue();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public TlabOptionCache() {
    }

    @Fold
    public static TlabOptionCache singleton() {
        return (TlabOptionCache)ImageSingletons.lookup(TlabOptionCache.class);
    }

    @Fold
    static long getAbsoluteMinTlabSize() {
        int additionalHeaderBytes = SubstrateOptions.AdditionalHeaderBytes.getValue();
        long absoluteMinTlabSize = 2048L + (long)additionalHeaderBytes;
        return NumUtil.roundUp((long)absoluteMinTlabSize, (long)ConfigurationValues.getObjectLayout().getAlignment());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getMinTlabSize() {
        return this.minTlabSize;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getTlabSize() {
        return this.tlabSize;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getInitialTLABSize() {
        return this.initialTLABSize;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void cacheOptionValues() {
        int minTlabSizeIdx = IsolateArgumentParser.getOptionIndex(SubstrateGCOptions.TlabOptions.MinTLABSize);
        long minTlabSizeValue = IsolateArgumentParser.singleton().getLongOptionValue(minTlabSizeIdx);
        this.cacheMinTlabSize(minTlabSizeValue);
        int tlabSizeIdx = IsolateArgumentParser.getOptionIndex(SubstrateGCOptions.TlabOptions.TLABSize);
        long tlabSizeValue = IsolateArgumentParser.singleton().getLongOptionValue(tlabSizeIdx);
        this.cacheTlabSize(tlabSizeValue);
        int initialTlabSizeIdx = IsolateArgumentParser.getOptionIndex(SerialAndEpsilonGCOptions.InitialTLABSize);
        long initialTlabSizeValue = IsolateArgumentParser.singleton().getLongOptionValue(initialTlabSizeIdx);
        this.cacheInitialTlabSize(initialTlabSizeValue, this.initialTLABSize != initialTlabSizeValue);
    }

    public static void registerOptionValidations() {
        long maxSize = TlabSupport.maxSize().rawValue();
        RuntimeOptionValidationSupport validationSupport = RuntimeOptionValidationSupport.singleton();
        validationSupport.register(new RuntimeOptionValidationSupport.RuntimeOptionValidation<Long>(optionKey -> {
            long minTlabSizeValue = (Long)optionKey.getValue();
            if (optionKey.hasBeenSet() && minTlabSizeValue < TlabOptionCache.getAbsoluteMinTlabSize()) {
                throw new IllegalArgumentException(String.format("MinTLABSize (%d) must be greater than or equal to reserved area in TLAB (%d).", minTlabSizeValue, TlabOptionCache.getAbsoluteMinTlabSize()));
            }
            if (minTlabSizeValue > maxSize) {
                throw new IllegalArgumentException(String.format("MinTLABSize (%d) must be less than or equal to ergonomic TLAB maximum (%d).", minTlabSizeValue, maxSize));
            }
        }, SubstrateGCOptions.TlabOptions.MinTLABSize));
        validationSupport.register(new RuntimeOptionValidationSupport.RuntimeOptionValidation<Long>(optionKey -> {
            long tlabSizeValue = (Long)optionKey.getValue();
            if (optionKey.hasBeenSet() && tlabSizeValue < SubstrateGCOptions.TlabOptions.MinTLABSize.getValue()) {
                throw new IllegalArgumentException(String.format("TLABSize (%d) must be greater than or equal to MinTLABSize (%d).", tlabSizeValue, SubstrateGCOptions.TlabOptions.MinTLABSize.getValue()));
            }
            if (tlabSizeValue > maxSize) {
                throw new IllegalArgumentException(String.format("TLABSize (%d) must be less than or equal to ergonomic TLAB maximum size (%d).", tlabSizeValue, maxSize));
            }
        }, SubstrateGCOptions.TlabOptions.TLABSize));
        validationSupport.register(new RuntimeOptionValidationSupport.RuntimeOptionValidation<Long>(optionKey -> {
            long initialTlabSizeValue = (Long)optionKey.getValue();
            if (initialTlabSizeValue < SubstrateGCOptions.TlabOptions.MinTLABSize.getValue()) {
                throw new IllegalArgumentException(String.format("InitialTLABSize (%d) must be greater than or equal to MinTLABSize (%d).", initialTlabSizeValue, SubstrateGCOptions.TlabOptions.MinTLABSize.getValue()));
            }
            if (initialTlabSizeValue > maxSize) {
                throw new IllegalArgumentException(String.format("TLABSize (%d) must be less than or equal to ergonomic TLAB maximum size (%d).", initialTlabSizeValue, maxSize));
            }
        }, SerialAndEpsilonGCOptions.InitialTLABSize));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void cacheMinTlabSize(long optionValue) {
        if (TlabOptionCache.getAbsoluteMinTlabSize() <= optionValue && optionValue <= TlabSupport.maxSize().rawValue()) {
            this.minTlabSize = optionValue;
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void cacheTlabSize(long optionValue) {
        if (TlabOptionCache.getAbsoluteMinTlabSize() <= optionValue && optionValue <= TlabSupport.maxSize().rawValue()) {
            this.tlabSize = optionValue;
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void cacheInitialTlabSize(long optionValue, boolean hasBeenSet) {
        if (!hasBeenSet && this.minTlabSize > this.initialTLABSize) {
            this.initialTLABSize = this.minTlabSize;
        } else if (TlabOptionCache.getAbsoluteMinTlabSize() <= optionValue && optionValue <= TlabSupport.maxSize().rawValue()) {
            this.initialTLABSize = UninterruptibleUtils.Math.max(this.minTlabSize, optionValue);
        }
    }
}

