/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.parallel;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.GreyToBlackObjRefVisitor;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.parallel.ChunkQueue;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.graal.nodes.WriteCurrentVMThreadNode;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.jdk.Jvm;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.ChunkBasedCommittedMemoryProvider;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import java.util.function.BooleanSupplier;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.RawPointerTo;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class ParallelGC {
    public static final int SCAN_CARD_TABLE = 0;
    public static final int SCAN_GREY_OBJECTS = 2;
    private static final int SCAN_OP_MASK = 2;
    private static final int UNALIGNED_BIT = 1;
    private static final UnsignedWord POINTER_MASK = WordFactory.unsigned((int)7).not();
    private static final int MAX_WORKER_THREADS = 8;
    private static final int CACHE_LINE_WORDS = 16;
    private final VMMutex mutex = new VMMutex("parallelGC");
    private final VMCondition seqPhase = new VMCondition(this.mutex);
    private final VMCondition parPhase = new VMCondition(this.mutex);
    private final ChunkQueue chunkQueue = new ChunkQueue();
    private final CEntryPointLiteral<CFunctionPointer> gcWorkerRunFunc = CEntryPointLiteral.create(ParallelGC.class, (String)"gcWorkerRun", (Class[])new Class[]{GCWorkerThreadState.class});
    private boolean initialized;
    private PlatformThreads.ThreadLocalKey workerStateTL;
    private GCWorkerThreadState workerStates;
    private UnsignedWord workerStatesSize;
    private VMThreads.OSThreadHandlePointer workerThreads;
    private int numWorkerThreads;
    private int busyWorkerThreads;
    private volatile Phase phase;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ParallelGC() {
    }

    @Fold
    public static ParallelGC singleton() {
        return (ParallelGC)ImageSingletons.lookup(ParallelGC.class);
    }

    @Fold
    public static boolean isEnabled() {
        return SubstrateOptions.useParallelGC();
    }

    @Fold
    static int wordSize() {
        return ConfigurationValues.getTarget().wordSize;
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    public boolean isInParallelPhase() {
        return this.phase == Phase.PARALLEL;
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    public VMMutex getMutex() {
        return this.mutex;
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    public Pointer getAllocChunkScanPointer(int age, boolean clear) {
        GCWorkerThreadState state = this.getWorkerThreadState();
        Pointer chunk = (Pointer)state.read(age);
        if (clear) {
            state.write(age, WordFactory.nullPointer());
        }
        return chunk;
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    public void setAllocChunk(int age, AlignedHeapChunk.AlignedHeader allocChunk) {
        Pointer top;
        Pointer scanPtr = (Pointer)WordFactory.nullPointer();
        if (allocChunk.isNonNull() && (top = HeapChunk.getTopPointer(allocChunk)).belowThan((UnsignedWord)HeapChunk.getEndPointer(allocChunk))) {
            scanPtr = top;
        }
        this.getWorkerThreadState().write(age, (PointerBase)scanPtr);
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    public void push(AlignedHeapChunk.AlignedHeader aChunk, int scanOp) {
        Pointer ptr = scanOp == 2 ? AlignedHeapChunk.getObjectsStart(aChunk) : HeapChunk.asPointer(aChunk);
        this.push(ptr, scanOp);
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    public void push(UnalignedHeapChunk.UnalignedHeader uChunk, int scanOp) {
        this.push(HeapChunk.asPointer(uChunk).or(1), scanOp);
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    private void push(Pointer ptr, int scanOp) {
        assert (ptr.isNonNull());
        ptr = ptr.or(scanOp);
        this.chunkQueue.push(ptr);
        if (this.phase == Phase.PARALLEL) {
            assert (this.mutex.isOwner(true));
            this.parPhase.signal();
        }
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    public void pushAllocChunk(Pointer ptr) {
        assert (ParallelGC.isEnabled() && ptr.isNonNull());
        GCWorkerThreadState state = this.getWorkerThreadState();
        AlignedHeapChunk.AlignedHeader chunk = AlignedHeapChunk.getEnclosingChunkFromObjectPointer(ptr);
        if (chunk.notEqual((ComparableWord)ParallelGC.getScannedChunk(state)) && HeapChunk.getTopPointer(chunk).aboveThan((UnsignedWord)ptr)) {
            this.push(ptr, 2);
        }
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    private GCWorkerThreadState getWorkerThreadState() {
        if (CurrentIsolate.getCurrentThread().isNull()) {
            return (GCWorkerThreadState)PlatformThreads.singleton().getUnmanagedThreadLocalValue(this.workerStateTL);
        }
        return this.workerStates;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.phase = Phase.PARALLEL;
        this.chunkQueue.initialize();
        this.workerStateTL = PlatformThreads.singleton().createUnmanagedThreadLocal();
        this.numWorkerThreads = this.busyWorkerThreads = ParallelGC.getWorkerCount();
        int workerStateWords = (ParallelGC.getStateWords() + 16 - 1) / 16 * 16;
        int numWorkerStates = this.numWorkerThreads + 1;
        this.workerStatesSize = WordFactory.unsigned((int)(workerStateWords * numWorkerStates * ParallelGC.wordSize()));
        this.workerStates = (GCWorkerThreadState)ChunkBasedCommittedMemoryProvider.get().allocateAlignedChunk(this.workerStatesSize, WordFactory.unsigned((int)(16 * ParallelGC.wordSize())));
        VMError.guarantee(this.workerStates.isNonNull());
        this.workerThreads = (VMThreads.OSThreadHandlePointer)ChunkBasedCommittedMemoryProvider.get().allocateUnalignedChunk(SizeOf.unsigned(VMThreads.OSThreadHandlePointer.class).multiply(this.numWorkerThreads));
        VMError.guarantee(this.workerThreads.isNonNull());
        for (int i = 0; i < this.numWorkerThreads; ++i) {
            GCWorkerThreadState workerState = this.workerStates.addressOf(workerStateWords * (i + 1));
            ParallelGC.setScannedChunk(workerState, (PointerBase)CurrentIsolate.getIsolate());
            VMThreads.OSThreadHandle thread = PlatformThreads.singleton().startThreadUnmanaged(this.gcWorkerRunFunc.getFunctionPointer(), workerState, 0);
            this.workerThreads.write(i, thread);
        }
        this.waitUntilWorkerThreadsFinish();
    }

    @Uninterruptible(reason="Tear-down in progress.")
    public void tearDown() {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        this.chunkQueue.teardown();
        this.phase = Phase.SHUTDOWN;
        this.parPhase.broadcast();
        for (int i = 0; i < this.numWorkerThreads; ++i) {
            VMThreads.OSThreadHandle thread = this.workerThreads.read(i);
            PlatformThreads.singleton().joinThreadUnmanaged(thread);
        }
        this.busyWorkerThreads = 0;
        ChunkBasedCommittedMemoryProvider.get().freeAlignedChunk(this.workerStates, this.workerStatesSize, WordFactory.unsigned((int)(16 * ParallelGC.wordSize())));
        ChunkBasedCommittedMemoryProvider.get().freeUnalignedChunk(this.workerThreads, SizeOf.unsigned(VMThreads.OSThreadHandlePointer.class).multiply(this.numWorkerThreads));
        this.workerThreads = (VMThreads.OSThreadHandlePointer)WordFactory.nullPointer();
        PlatformThreads.singleton().deleteUnmanagedThreadLocal(this.workerStateTL);
        this.workerStateTL = (PlatformThreads.ThreadLocalKey)WordFactory.nullPointer();
        this.numWorkerThreads = 0;
        this.mutex.lockNoTransitionUnspecifiedOwner();
        try {
            this.doCleanup();
        }
        finally {
            this.mutex.unlockNoTransitionUnspecifiedOwner();
        }
    }

    private static int getWorkerCount() {
        int setting = SubstrateOptions.DeprecatedOptions.ParallelGCThreads.getValue();
        int workerCount = setting > 0 ? setting : ParallelGC.getDefaultWorkerCount();
        ParallelGC.verboseGCLog().string("[Number of ParallelGC threads: ").unsigned(workerCount).string("]").newline();
        return workerCount;
    }

    private static int getDefaultWorkerCount() {
        int cpus = Jvm.JVM_ActiveProcessorCount();
        return UninterruptibleUtils.Math.min(cpus, 8);
    }

    @Uninterruptible(reason="Heap base is not set up yet.")
    @CEntryPoint(include=UseParallelGC.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=GCWorkerThreadPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    private static void gcWorkerRun(GCWorkerThreadState state) {
        try {
            ParallelGC.singleton().work(state);
        }
        catch (Throwable e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @NeverInline(value="Prevent reads from floating up.")
    @Uninterruptible(reason="Called from a GC worker thread.")
    private void work(GCWorkerThreadState state) {
        PlatformThreads.singleton().setUnmanagedThreadLocalValue(this.workerStateTL, (WordBase)state);
        try {
            this.work0(state);
        }
        catch (Throwable e) {
            VMError.shouldNotReachHere(e);
        }
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    private void work0(GCWorkerThreadState state) {
        while (this.phase != Phase.SHUTDOWN) {
            Pointer ptr;
            this.mutex.lockNoTransitionUnspecifiedOwner();
            try {
                ptr = this.chunkQueue.pop();
                if (ptr.isNull() && this.getNextAllocChunkScanPointer(false).isNull()) {
                    this.decrementBusyWorkers();
                    do {
                        this.parPhase.blockNoTransitionUnspecifiedOwner();
                        this.attemptCleanup();
                    } while (this.phase == Phase.SEQUENTIAL);
                    this.incrementBusyWorkers();
                }
            }
            finally {
                this.mutex.unlockNoTransitionUnspecifiedOwner();
            }
            if (ptr.isNonNull()) {
                ParallelGC.scanChunk(ptr);
                continue;
            }
            this.scanAllocChunk(state);
        }
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    private static void scanChunk(Pointer ptr) {
        assert (ptr.isNonNull());
        boolean aligned = ptr.and(1).notEqual(1);
        Pointer op = ptr.and(2);
        ptr = ptr.and(POINTER_MASK);
        GreyToBlackObjectVisitor visitor = GCImpl.getGCImpl().getGreyToBlackObjectVisitor();
        if (op.equal(0)) {
            AlignedHeapChunk.AlignedHeader aChunk = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
            UnalignedHeapChunk.UnalignedHeader uChunk = (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer();
            if (aligned) {
                aChunk = (AlignedHeapChunk.AlignedHeader)ptr;
            } else {
                uChunk = (UnalignedHeapChunk.UnalignedHeader)ptr;
            }
            GreyToBlackObjRefVisitor refVisitor = GCImpl.getGCImpl().getGreyToBlackObjRefVisitor();
            RememberedSet.get().walkDirtyObjects(aChunk, uChunk, (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer(), visitor, refVisitor, true);
        } else if (op.equal(2)) {
            if (aligned) {
                AlignedHeapChunk.AlignedHeader aChunk = AlignedHeapChunk.getEnclosingChunkFromObjectPointer(ptr);
                HeapChunk.walkObjectsFromInline(aChunk, ptr, visitor);
            } else {
                UnalignedHeapChunk.UnalignedHeader uChunk = (UnalignedHeapChunk.UnalignedHeader)ptr;
                UnalignedHeapChunk.walkObjectsInline(uChunk, visitor);
            }
        } else {
            VMError.shouldNotReachHere("Unknown opcode");
        }
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    private void scanAllocChunk(GCWorkerThreadState state) {
        Pointer scanPtr = this.getNextAllocChunkScanPointer(false);
        if (scanPtr.isNonNull()) {
            AlignedHeapChunk.AlignedHeader allocChunk = AlignedHeapChunk.getEnclosingChunkFromObjectPointer(scanPtr);
            ParallelGC.setScannedChunk(state, allocChunk);
            allocChunk.getSpace().walkAllocChunk(allocChunk, scanPtr, GCImpl.getGCImpl().getGreyToBlackObjectVisitor());
            ParallelGC.setScannedChunk(state, WordFactory.nullPointer());
        }
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    private Pointer getNextAllocChunkScanPointer(boolean clear) {
        for (int i = 1; i < ParallelGC.getStateWords(); ++i) {
            AlignedHeapChunk.AlignedHeader allocChunk;
            Pointer scanPtr = this.getAllocChunkScanPointer(i, clear);
            if (!scanPtr.isNonNull() || !HeapChunk.getTopPointer(allocChunk = AlignedHeapChunk.getEnclosingChunkFromObjectPointer(scanPtr)).aboveThan((UnsignedWord)scanPtr)) continue;
            return scanPtr;
        }
        return (Pointer)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    private void incrementBusyWorkers() {
        assert (this.mutex.isOwner(true));
        ++this.busyWorkerThreads;
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    private void decrementBusyWorkers() {
        assert (this.mutex.isOwner(true));
        if (--this.busyWorkerThreads == 0) {
            this.phase = Phase.SEQUENTIAL;
            this.seqPhase.signal();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void scheduleScan() {
        Pointer allocChunk;
        while ((allocChunk = this.getNextAllocChunkScanPointer(true)).isNonNull()) {
            this.push(allocChunk, 2);
        }
        UnmanagedMemoryUtil.fillLongs((Pointer)this.workerStates, this.workerStatesSize, 0L);
        this.mutex.lockNoTransitionUnspecifiedOwner();
        try {
            this.waitUntilWorkerThreadsFinish0();
            this.phase = Phase.PARALLEL;
            this.parPhase.broadcast();
            this.waitUntilWorkerThreadsFinish0();
        }
        finally {
            this.mutex.unlockNoTransitionUnspecifiedOwner();
        }
        assert (this.chunkQueue.isEmpty());
        assert (this.phase != Phase.PARALLEL);
        assert (this.busyWorkerThreads == 0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void waitUntilWorkerThreadsFinish() {
        this.mutex.lockNoTransitionUnspecifiedOwner();
        try {
            this.waitUntilWorkerThreadsFinish0();
        }
        finally {
            this.mutex.unlockNoTransitionUnspecifiedOwner();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void waitUntilWorkerThreadsFinish0() {
        while (this.phase != Phase.SEQUENTIAL) {
            this.seqPhase.blockNoTransitionUnspecifiedOwner();
        }
    }

    public void scheduleCleanup() {
        this.mutex.lock();
        try {
            this.phase = Phase.CLEANUP;
            this.parPhase.signal();
        }
        finally {
            this.mutex.unlock();
        }
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    private void attemptCleanup() {
        if (this.phase == Phase.CLEANUP) {
            this.doCleanup();
            this.phase = Phase.SEQUENTIAL;
            this.seqPhase.signal();
        }
    }

    @Uninterruptible(reason="Called from a GC worker thread.")
    private void doCleanup() {
        assert (this.mutex.isOwner(true) || this.phase == Phase.SHUTDOWN);
        GCImpl.getGCImpl().freeChunks();
    }

    private static Log verboseGCLog() {
        return SubstrateGCOptions.VerboseGC.getValue() != false ? Log.log() : Log.noopLog();
    }

    @Fold
    static int getStateWords() {
        return HeapParameters.getMaxSurvivorSpaces() + 2;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static PointerBase getScannedChunk(GCWorkerThreadState state) {
        return state.read(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void setScannedChunk(GCWorkerThreadState state, PointerBase chunkPointer) {
        state.write(0, chunkPointer);
    }

    @RawPointerTo(value=AlignedChunkPointer.class)
    static interface GCWorkerThreadState
    extends PointerBase {
        public PointerBase read(int var1);

        public void write(int var1, PointerBase var2);

        public GCWorkerThreadState addressOf(int var1);

        @RawStructure
        public static interface AlignedChunkPointer
        extends PointerBase {
        }
    }

    private static enum Phase {
        SEQUENTIAL,
        PARALLEL,
        CLEANUP,
        SHUTDOWN;

    }

    private static class UseParallelGC
    implements BooleanSupplier {
        private UseParallelGC() {
        }

        @Override
        public boolean getAsBoolean() {
            return ParallelGC.isEnabled();
        }
    }

    private static class GCWorkerThreadPrologue
    implements CEntryPointOptions.Prologue {
        private GCWorkerThreadPrologue() {
        }

        @Uninterruptible(reason="prologue")
        public static void enter(GCWorkerThreadState state) {
            CEntryPointSnippets.setHeapBase(ParallelGC.getScannedChunk(state));
            WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)WordFactory.nullPointer());
        }
    }
}

