/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64Backend;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInsertionBuffer;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64Call;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.framemap.FrameMapBuilderTool;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.phases.PreAllocationOptimizationPhase;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.TargetDescription;

public class FramePointerPhase
extends PreAllocationOptimizationPhase {
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PreAllocationOptimizationPhase.PreAllocationOptimizationContext context) {
        if (!FramePointerPhase.isSupported(lirGenRes)) {
            return;
        }
        LIR lir = lirGenRes.getLIR();
        if (!FramePointerPhase.modifiesStackPointer(lir)) {
            return;
        }
        ((SubstrateAMD64Backend.SubstrateAMD64RegisterAllocationConfig)lirGenRes.getRegisterAllocationConfig()).setPreserveFramePointer();
        ((SubstrateAMD64Backend.SubstrateAMD64FrameMap)((FrameMapBuilderTool)lirGenRes.getFrameMapBuilder()).getFrameMap()).setNeedsFramePointer();
        if (!SubstrateOptions.PreserveFramePointer.getValue().booleanValue()) {
            LIRInsertionBuffer buffer = new LIRInsertionBuffer();
            for (int blockId : lir.getBlocks()) {
                if (LIR.isBlockDeleted((int)blockId)) continue;
                BasicBlock block = lir.getBlockById(blockId);
                ArrayList instructions = lir.getLIRforBlock(block);
                buffer.init((List)instructions);
                if (block.isExceptionEntry()) {
                    buffer.append(lirGenRes.getFirstInsertPosition(), (LIRInstruction)new SpillFramePointerOp(true));
                    buffer.append(lirGenRes.getFirstInsertPosition(), (LIRInstruction)new ReloadFramePointerOp());
                }
                for (int i = 0; i < instructions.size(); ++i) {
                    Object e = instructions.get(i);
                    if (!(e instanceof AMD64Call.CallOp)) continue;
                    AMD64Call.CallOp callOp = (AMD64Call.CallOp)e;
                    buffer.append(i, (LIRInstruction)new SpillFramePointerOp());
                    buffer.append(i + 1, (LIRInstruction)new ReloadFramePointerOp(!callOp.destroysCallerSavedRegisters()));
                }
                buffer.finish();
            }
        }
    }

    static boolean isSupported(LIRGenerationResult lirGenRes) {
        SubstrateAMD64Backend.SubstrateLIRGenerationResult result = (SubstrateAMD64Backend.SubstrateLIRGenerationResult)lirGenRes;
        return SubstrateUtil.HOSTED && !result.getMethod().isDeoptTarget();
    }

    private static boolean modifiesStackPointer(LIR lir) {
        for (int blockId : lir.getBlocks()) {
            if (LIR.isBlockDeleted((int)blockId)) continue;
            BasicBlock block = lir.getBlockById(blockId);
            for (LIRInstruction op : lir.getLIRforBlock(block)) {
                if (!op.modifiesStackPointer()) continue;
                return true;
            }
        }
        return false;
    }

    @Opcode(value="SPILL_FRAME_POINTER")
    public static class SpillFramePointerOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<SpillFramePointerOp> TYPE = LIRInstructionClass.create(SpillFramePointerOp.class);
        private final boolean recordMarkOnly;

        SpillFramePointerOp() {
            this(false);
        }

        SpillFramePointerOp(boolean recordMarkOnly) {
            super(TYPE);
            this.recordMarkOnly = recordMarkOnly;
        }

        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (!this.recordMarkOnly) {
                SubstrateAMD64Backend.SubstrateAMD64FrameMap frameMap = (SubstrateAMD64Backend.SubstrateAMD64FrameMap)crb.frameMap;
                masm.movq(masm.makeAddress(AMD64.rsp, frameMap.getFramePointerSaveAreaOffset()), AMD64.rbp);
            }
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.FRAME_POINTER_SPILLED);
        }
    }

    @Opcode(value="RELOAD_FRAME_POINTER")
    public static class ReloadFramePointerOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<ReloadFramePointerOp> TYPE = LIRInstructionClass.create(ReloadFramePointerOp.class);
        private final boolean recordMarkOnly;

        ReloadFramePointerOp() {
            this(false);
        }

        ReloadFramePointerOp(boolean recordMarkOnly) {
            super(TYPE);
            this.recordMarkOnly = recordMarkOnly;
        }

        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (!this.recordMarkOnly) {
                SubstrateAMD64Backend.SubstrateAMD64FrameMap frameMap = (SubstrateAMD64Backend.SubstrateAMD64FrameMap)crb.frameMap;
                masm.movq(AMD64.rbp, masm.makeAddress(AMD64.rsp, frameMap.getFramePointerSaveAreaOffset()));
            }
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.FRAME_POINTER_RELOADED);
        }
    }
}

