/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.util.NonmovableByteArrayReader;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;

public class CodeReferenceMapDecoder {
    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void walkOffsetsFromPointer(PointerBase baseAddress, NonmovableArray<Byte> referenceMapEncoding, long referenceMapIndex, ObjectReferenceVisitor visitor, Object holderObject) {
        assert (referenceMapIndex != -1L);
        assert (referenceMapEncoding.isNonNull());
        int uncompressedSize = FrameAccess.uncompressedReferenceSize();
        int compressedSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        Pointer objRef = (Pointer)baseAddress;
        long idx = referenceMapIndex;
        boolean firstRun = true;
        while (true) {
            long count;
            long gap;
            if ((gap = (long)NonmovableByteArrayReader.getU1(referenceMapEncoding, idx++)) >= 192L) {
                long shift = 6L;
                int i = 2;
                while (true) {
                    long b = NonmovableByteArrayReader.getU1(referenceMapEncoding, idx++);
                    gap += b << (int)shift;
                    if (b < 192L || (long)i == 11L) break;
                    shift += 6L;
                    ++i;
                }
            }
            gap = CodeReferenceMapDecoder.decodeSign(gap);
            if ((count = (long)NonmovableByteArrayReader.getU1(referenceMapEncoding, idx++)) >= 192L) {
                long shift = 6L;
                int i = 2;
                while (true) {
                    long b = NonmovableByteArrayReader.getU1(referenceMapEncoding, idx++);
                    count += b << (int)shift;
                    if (b < 192L || (long)i == 11L) break;
                    shift += 6L;
                    ++i;
                }
            }
            count = CodeReferenceMapDecoder.decodeSign(count);
            if (gap == 0L && count == 0L) break;
            boolean derived = false;
            if (!firstRun && gap < 0L) {
                gap = -(gap + 1L);
                derived = true;
            }
            firstRun = false;
            objRef = objRef.add(Word.unsigned((long)gap));
            boolean compressed = count < 0L;
            int refSize = compressed ? compressedSize : uncompressedSize;
            long l = count = count < 0L ? -count : count;
            if (derived) {
                CodeReferenceMapDecoder.callVisitObjectReferencesInline(visitor, objRef, compressed, refSize, holderObject, 1);
                for (long d = 0L; d < count; ++d) {
                    long refOffset;
                    if ((refOffset = (long)NonmovableByteArrayReader.getU1(referenceMapEncoding, idx++)) >= 192L) {
                        long shift = 6L;
                        int i = 2;
                        while (true) {
                            long b = NonmovableByteArrayReader.getU1(referenceMapEncoding, idx++);
                            refOffset += b << (int)shift;
                            if (b < 192L || (long)i == 11L) break;
                            shift += 6L;
                            ++i;
                        }
                    }
                    Pointer derivedRef = (refOffset = CodeReferenceMapDecoder.decodeSign(refOffset)) >= 0L ? objRef.add(Word.unsigned((long)refOffset).multiply(refSize)) : objRef.subtract(Word.unsigned((long)(-refOffset)).multiply(refSize));
                    CodeReferenceMapDecoder.callVisitDerivedReferenceInline(visitor, objRef, derivedRef, holderObject);
                }
                objRef = objRef.add(refSize);
                continue;
            }
            assert ((long)((int)count) == count);
            CodeReferenceMapDecoder.callVisitObjectReferencesInline(visitor, objRef, compressed, refSize, holderObject, (int)count);
            objRef = objRef.add(Word.unsigned((long)count).multiply(refSize));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long decodeSign(long value) {
        return value >>> 1 ^ -(value & 1L);
    }

    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="Bridge between uninterruptible and potentially interruptible code.", mayBeInlined=true, calleeMustBe=false)
    private static void callVisitObjectReferencesInline(ObjectReferenceVisitor visitor, Pointer firstObjRef, boolean compressed, int referenceSize, Object holderObject, int count) {
        visitor.visitObjectReferences(firstObjRef, compressed, referenceSize, holderObject, count);
    }

    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="Bridge between uninterruptible and potentially interruptible code.", mayBeInlined=true, calleeMustBe=false)
    private static void callVisitDerivedReferenceInline(ObjectReferenceVisitor visitor, Pointer baseObjRef, Pointer derivedObjRef, Object holderObject) {
        visitor.visitDerivedReference(baseObjRef, derivedObjRef, holderObject);
    }
}

