/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.code.FrameSourceInfo;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.stack.JavaStackFrameVisitor;

class GetCallerClassVisitor
extends JavaStackFrameVisitor {
    private final boolean showLambdaFrames;
    private int depth;
    private boolean ignoreFirst;
    Class<?> result;

    GetCallerClassVisitor(boolean showLambdaFrames, int depth, boolean ignoreFirst) {
        this.showLambdaFrames = showLambdaFrames;
        this.ignoreFirst = ignoreFirst;
        this.depth = depth;
        assert (depth >= 0);
    }

    @Override
    public boolean visitFrame(FrameSourceInfo frameSourceInfo) {
        assert (this.depth >= 0);
        if (this.ignoreFirst) {
            this.ignoreFirst = false;
            return true;
        }
        if (!StackTraceUtils.shouldShowFrame(frameSourceInfo, this.showLambdaFrames, false, false)) {
            return true;
        }
        if (this.depth > 0) {
            --this.depth;
            return true;
        }
        this.result = frameSourceInfo.getSourceClass();
        return false;
    }
}

