/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.jdk.JDKUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.VMThreads;
import jdk.graal.compiler.nodes.UnreachableNode;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.function.CodePointer;

public class VMErrorSubstitutions {
    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in fatal error handling.")
    static RuntimeException shouldNotReachHere(CodePointer callerIP, String msg, Throwable ex) {
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue() && CurrentIsolate.getCurrentThread().isNull()) {
            CEntryPointSnippets.enterAttachFromCrashHandler((Isolate)KnownIntrinsics.heapBase());
        }
        VMThreads.SafepointBehavior.preventSafepoints();
        StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
        VMErrorSubstitutions.shutdown(callerIP, msg, ex);
        throw UnreachableNode.unreachable();
    }

    @Uninterruptible(reason="Allow use in uninterruptible code.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate during printing diagnostics.")
    static void shutdown(CodePointer callerIP, String msg, Throwable ex) {
        VMErrorSubstitutions.doShutdown(callerIP, msg, ex);
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    private static void doShutdown(CodePointer callerIP, String msg, Throwable ex) {
        LogHandler logHandler = (LogHandler)ImageSingletons.lookup(LogHandler.class);
        Log log = Log.enterFatalContext(logHandler, callerIP, msg, ex);
        if (log != null) {
            try {
                log.string("Fatal error");
                if (msg != null) {
                    log.string(": ").string(msg);
                }
                if (ex != null) {
                    log.string(": ").exception(ex);
                }
                log.newline();
                SubstrateDiagnostics.printFatalError(log, KnownIntrinsics.readCallerStackPointer(), KnownIntrinsics.readReturnAddress());
                log.string("Fatal error");
                if (msg != null) {
                    log.string(": ").string(msg);
                }
                if (ex != null) {
                    log.string(": ").string(ex.getClass().getName()).string(": ").string(JDKUtils.getRawMessage(ex));
                }
                log.newline();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        logHandler.fatalError();
    }
}

