/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.RuntimeJNIAccess;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeJNIAccessSupport;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class JNIRuntimeAccess {
    private JNIRuntimeAccess() {
    }

    public static void register(Class<?> ... classes) {
        RuntimeJNIAccess.register((Class[])classes);
    }

    public static void register(Executable ... methods) {
        RuntimeJNIAccess.register((Executable[])methods);
    }

    public static void register(Field ... fields) {
        RuntimeJNIAccess.register((Field[])fields);
    }

    public static void register(boolean finalIsWritable, Field ... fields) {
        ((RuntimeJNIAccessSupport)ImageSingletons.lookup(RuntimeJNIAccessSupport.class)).register(ConfigurationCondition.alwaysTrue(), finalIsWritable, fields);
    }
}

