/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni.access;

import com.oracle.svm.core.jni.access.JNIReflectionDictionary;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public final class JNIAccessibleMethodDescriptor {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String INITIALIZER_NAME = "<clinit>";
    private final CharSequence name;
    private final CharSequence signature;

    public static JNIAccessibleMethodDescriptor of(JavaMethod method) {
        String sig = method.getSignature().toMethodDescriptor();
        assert (!sig.contains(".")) : "Malformed signature (needs to use '/' as package separator)";
        return new JNIAccessibleMethodDescriptor(method.getName(), sig);
    }

    public static JNIAccessibleMethodDescriptor of(Executable method) {
        Class<Void> returnType;
        String name = method.getName();
        if (method instanceof Constructor) {
            name = CONSTRUCTOR_NAME;
            returnType = Void.TYPE;
        } else if (method instanceof Method) {
            returnType = ((Method)method).getReturnType();
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput(method);
        }
        return JNIAccessibleMethodDescriptor.of(name, method.getParameterTypes(), returnType);
    }

    public static JNIAccessibleMethodDescriptor of(String methodName, Class<?>[] parameterTypes) {
        return JNIAccessibleMethodDescriptor.of(methodName, parameterTypes, null);
    }

    private static JNIAccessibleMethodDescriptor of(String methodName, Class<?>[] parameterTypes, Class<?> returnType) {
        StringBuilder sb = new StringBuilder("(");
        for (Class<?> type : parameterTypes) {
            sb.append(MetaUtil.toInternalName((String)type.getName()));
        }
        sb.append(')');
        if (returnType != null) {
            sb.append(MetaUtil.toInternalName((String)returnType.getName()));
        }
        assert (sb.indexOf(".") == -1) : "Malformed signature (needs to use '/' as package separator)";
        return new JNIAccessibleMethodDescriptor(methodName, sb.toString());
    }

    JNIAccessibleMethodDescriptor(CharSequence name, CharSequence signature) {
        this.name = name;
        this.signature = signature;
    }

    public boolean isConstructor() {
        return JNIReflectionDictionary.WRAPPED_CSTRING_EQUIVALENCE.equals((Object)this.name, (Object)CONSTRUCTOR_NAME);
    }

    public boolean isClassInitializer() {
        return JNIReflectionDictionary.WRAPPED_CSTRING_EQUIVALENCE.equals((Object)this.name, (Object)INITIALIZER_NAME);
    }

    public String getName() {
        return (String)this.name;
    }

    public String getSignature() {
        return (String)this.signature;
    }

    public String getNameConvertToString() {
        return this.name.toString();
    }

    public String getSignatureConvertToString() {
        return this.signature.toString();
    }

    public String getSignatureWithoutReturnType() {
        String signatureString = this.signature.toString();
        int parametersEnd = signatureString.lastIndexOf(41);
        if (!signatureString.isEmpty() && signatureString.charAt(0) == '(' && parametersEnd != -1) {
            return signatureString.substring(0, parametersEnd + 1);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JNIAccessibleMethodDescriptor) {
            JNIAccessibleMethodDescriptor other = (JNIAccessibleMethodDescriptor)obj;
            return other == this || JNIReflectionDictionary.WRAPPED_CSTRING_EQUIVALENCE.equals((Object)this.name, (Object)other.name) && JNIReflectionDictionary.WRAPPED_CSTRING_EQUIVALENCE.equals((Object)this.signature, (Object)other.signature);
        }
        return false;
    }

    public boolean matchesIgnoreReturnType(ResolvedJavaMethod method) {
        if (!this.getName().equals(method.getName())) {
            return false;
        }
        int position = 1;
        for (JavaType parameterType : method.getSignature().toParameterTypes(null)) {
            String paramInternal = parameterType.getName();
            if (!this.getSignature().startsWith(paramInternal, position)) {
                return false;
            }
            position += paramInternal.length();
        }
        return this.getSignature().startsWith(")", position);
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.signature.hashCode();
    }
}

