/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmti.headers;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.util.BasedOnJDKFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.c.CContext;

@BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+23/src/hotspot/share/prims/jvmti.xml"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+11/src/hotspot/share/prims/jvmtiH.xsl")})
class JvmtiDirectives
implements CContext.Directives {
    private final Path jdkIncludeDir = Paths.get(System.getProperty("java.home"), new String[0]).resolve("include");

    JvmtiDirectives() {
    }

    public boolean isInConfiguration() {
        return SubstrateOptions.JVMTI.getValue();
    }

    public List<String> getHeaderFiles() {
        return Collections.singletonList("\"" + String.valueOf(this.jdkIncludeDir.resolve("jvmti.h")) + "\"");
    }

    public List<String> getOptions() {
        return Collections.singletonList("-I" + String.valueOf(this.jdkIncludeDir.resolve(OS.getCurrent() == OS.WINDOWS ? "win32" : OS.getCurrent().asPackageName())));
    }
}

