/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.memory;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.memory.UntrackedNullableNativeMemory;
import com.oracle.svm.core.nmt.NativeMemoryTracking;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.nmt.NmtMallocHeader;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public class NullableNativeMemory {
    public static final byte UNINITIALIZED_NATIVE_MEMORY = -70;
    private static final byte FREED_NATIVE_MEMORY = -66;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T malloc(UnsignedWord size, NmtCategory category) {
        Object outerPointer = UntrackedNullableNativeMemory.malloc(NullableNativeMemory.getAllocationSize(size));
        Object innerPtr = NullableNativeMemory.track(outerPointer, size, category);
        if (SubstrateOptions.ZapNativeMemory.getValue().booleanValue() && VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            UnmanagedMemoryUtil.fill((Pointer)innerPtr, size, (byte)-70);
        }
        return innerPtr;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T malloc(int size, NmtCategory category) {
        assert (size >= 0);
        return NullableNativeMemory.malloc(Word.unsigned((int)size), category);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T calloc(UnsignedWord size, NmtCategory category) {
        Object outerPointer = UntrackedNullableNativeMemory.calloc(NullableNativeMemory.getAllocationSize(size));
        return NullableNativeMemory.track(outerPointer, size, category);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T calloc(int size, NmtCategory category) {
        assert (size >= 0);
        return NullableNativeMemory.calloc(Word.unsigned((int)size), category);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T realloc(T ptr, UnsignedWord size, NmtCategory category) {
        NmtMallocHeader header;
        if (ptr.isNull()) {
            return NullableNativeMemory.malloc(size, category);
        }
        if (!VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            return UntrackedNullableNativeMemory.realloc(ptr, NullableNativeMemory.getAllocationSize(size));
        }
        NmtMallocHeader oldOuterPointer = header = NativeMemoryTracking.getHeader(ptr);
        int oldCategory = header.getCategory();
        UnsignedWord oldSize = header.getAllocationSize();
        NmtMallocHeader newOuterPointer = UntrackedNullableNativeMemory.realloc(oldOuterPointer, NullableNativeMemory.getAllocationSize(size));
        if (newOuterPointer.isNull()) {
            return (T)Word.nullPointer();
        }
        oldOuterPointer = Word.nullPointer();
        NativeMemoryTracking.singleton().untrack(oldSize, oldCategory);
        NmtMallocHeader newInnerPtr = NullableNativeMemory.track(newOuterPointer, size, category);
        if (SubstrateOptions.ZapNativeMemory.getValue().booleanValue() && VMInspectionOptions.hasNativeMemoryTrackingSupport() && size.aboveThan(oldSize)) {
            UnsignedWord numUninitializedBytes = size.subtract(oldSize);
            Pointer uninitializedStart = ((Pointer)newInnerPtr).add(oldSize);
            UnmanagedMemoryUtil.fill(uninitializedStart, numUninitializedBytes, (byte)-70);
        }
        return (T)newInnerPtr;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T realloc(T ptr, int size, NmtCategory category) {
        assert (size >= 0);
        return NullableNativeMemory.realloc(ptr, Word.unsigned((int)size), category);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void free(PointerBase ptr) {
        if (ptr.isNull()) {
            return;
        }
        if (SubstrateOptions.ZapNativeMemory.getValue().booleanValue() && VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            NmtMallocHeader header = NativeMemoryTracking.getHeader(ptr);
            UnmanagedMemoryUtil.fill((Pointer)ptr, header.getAllocationSize(), (byte)-66);
        }
        PointerBase outerPtr = NullableNativeMemory.untrack(ptr);
        UntrackedNullableNativeMemory.free(outerPtr);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getAllocationSize(UnsignedWord size) {
        if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            return size.add(NativeMemoryTracking.sizeOfNmtHeader());
        }
        return size;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static <T extends PointerBase> T track(T outerPtr, UnsignedWord size, NmtCategory category) {
        if (VMInspectionOptions.hasNativeMemoryTrackingSupport() && outerPtr.isNonNull()) {
            Pointer innerPtr = NativeMemoryTracking.singleton().initializeHeader(outerPtr, size, category);
            NativeMemoryTracking.singleton().track((PointerBase)innerPtr);
            return (T)innerPtr;
        }
        return outerPtr;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static PointerBase untrack(PointerBase innerPtr) {
        if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            return NativeMemoryTracking.singleton().untrack(innerPtr);
        }
        return innerPtr;
    }
}

