/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.option.RuntimeOptionParser;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.option.XOptions;
import com.oracle.svm.util.ClassUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.options.OptionsParser;
import org.graalvm.nativeimage.RuntimeOptions;
import org.graalvm.nativeimage.impl.RuntimeOptionsSupport;

@AutomaticallyRegisteredImageSingleton(value={RuntimeOptionsSupport.class})
class RuntimeOptionsSupportImpl
implements RuntimeOptionsSupport {
    RuntimeOptionsSupportImpl() {
    }

    public void set(String optionName, Object value) {
        if (XOptions.setOption(optionName)) {
            return;
        }
        if (!RuntimeOptionValues.singleton().getAllOptionNames().contains((Object)optionName)) {
            throw new RuntimeException("Unknown option: " + optionName);
        }
        Optional<OptionDescriptor> descriptor = RuntimeOptionParser.singleton().getDescriptor(optionName);
        if (descriptor.isPresent()) {
            OptionDescriptor desc = descriptor.get();
            Class<?> valueType = value.getClass();
            if (desc.getOptionValueType().isAssignableFrom(valueType)) {
                RuntimeOptionValues.singleton().update(desc.getOptionKey(), value);
            } else {
                throw new RuntimeException("Invalid type of option '" + optionName + "': required " + ClassUtil.getUnqualifiedName((Class)desc.getOptionValueType()) + ", provided " + String.valueOf(valueType));
            }
        }
    }

    public <T> T get(String optionName) {
        if (!RuntimeOptionValues.singleton().getAllOptionNames().contains((Object)optionName)) {
            throw new RuntimeException("Unknown option: " + optionName);
        }
        Optional<OptionDescriptor> descriptor = RuntimeOptionParser.singleton().getDescriptor(optionName);
        OptionKey optionKey = descriptor.orElseThrow(() -> new RuntimeException("Option " + optionName + " exists but it is not reachable in the application. It is not possible to get its value.")).getOptionKey();
        return (T)optionKey.getValue((OptionValues)RuntimeOptionValues.singleton());
    }

    public List<RuntimeOptions.Descriptor> listDescriptors() {
        ArrayList<RuntimeOptions.Descriptor> options = new ArrayList<RuntimeOptions.Descriptor>();
        Iterable<OptionDescriptor> descriptors = RuntimeOptionParser.singleton().getDescriptors();
        for (OptionDescriptor descriptor : descriptors) {
            DescriptorImpl option = RuntimeOptionsSupportImpl.asDescriptor(descriptor);
            if (option == null) continue;
            options.add(option);
        }
        return options;
    }

    private static DescriptorImpl asDescriptor(OptionDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Object help = (String)descriptor.getHelp().getFirst();
        int helpLen = ((String)help).length();
        if (helpLen > 0 && ((String)help).charAt(helpLen - 1) != '.') {
            help = (String)help + ".";
        }
        return new DescriptorImpl(descriptor.getName(), (String)help, descriptor.getOptionValueType(), descriptor.getOptionKey().getDefaultValue(), descriptor.isDeprecated(), descriptor.getDeprecationMessage());
    }

    public RuntimeOptions.Descriptor getDescriptor(String optionName) {
        return RuntimeOptionsSupportImpl.asDescriptor(RuntimeOptionParser.singleton().getDescriptor(optionName).orElse(null));
    }

    record DescriptorImpl(String name, String help, Class<?> valueType, Object defaultValue, boolean deprecated, String deprecatedMessage) implements RuntimeOptions.Descriptor
    {
        public Object convertValue(String value) throws IllegalArgumentException {
            Optional<OptionDescriptor> descriptor = RuntimeOptionParser.singleton().getDescriptor(this.name);
            return OptionsParser.parseOptionValue((OptionDescriptor)descriptor.get(), (Object)value);
        }
    }
}

