/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers.linux;

import com.oracle.svm.core.posix.headers.PosixDirectives;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.posix.headers.Time;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

@CContext(value=PosixDirectives.class)
public class LinuxTime
extends Time {
    @CConstant
    public static native int CLOCK_MONOTONIC();

    @CConstant
    public static native int CLOCK_THREAD_CPUTIME_ID();

    public static class NoTransitions {
        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        @CLibrary(value="rt")
        public static native int clock_gettime(int var0, Time.timespec var1);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int timer_create(int var0, Signal.sigevent var1, WordPointer var2);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int timer_settime(UnsignedWord var0, int var1, itimerspec var2, itimerspec var3);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int timer_delete(UnsignedWord var0);
    }

    @CStruct(addStructKeyword=true)
    public static interface itimerspec
    extends PointerBase {
        @CFieldAddress
        public Time.timespec it_interval();

        @CFieldAddress
        public Time.timespec it_value();
    }

    @CStruct
    public static interface timer_t
    extends PointerBase {
    }
}

