/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.RawFileOperationSupport;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.Pointer;

class DumpLinuxOSInfo
extends SubstrateDiagnostics.DiagnosticThunk {
    private static final CGlobalData<CCharPointer> MAX_THREADS_PATH = CGlobalDataFactory.createCString("/proc/sys/kernel/threads-max");
    private static final CGlobalData<CCharPointer> MAX_MAPPINGS_PATH = CGlobalDataFactory.createCString("/proc/sys/vm/max_map_count");
    private static final CGlobalData<CCharPointer> MAX_PID_PATH = CGlobalDataFactory.createCString("/proc/sys/kernel/pid_max");

    DumpLinuxOSInfo() {
    }

    @Override
    public int maxInvocationCount() {
        return 1;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
    public void printDiagnostics(Log log, SubstrateDiagnostics.ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
        log.string("OS information:").indent(true);
        log.string("Max threads: ");
        DumpLinuxOSInfo.printFirstLine(log, MAX_THREADS_PATH.get());
        log.newline();
        log.string("Max memory mappings: ");
        DumpLinuxOSInfo.printFirstLine(log, MAX_MAPPINGS_PATH.get());
        log.newline();
        log.string("Max PID: ");
        DumpLinuxOSInfo.printFirstLine(log, MAX_PID_PATH.get());
        log.newline();
        log.indent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printFirstLine(Log log, CCharPointer filename) {
        RawFileOperationSupport.RawFileDescriptor fd;
        RawFileOperationSupport fs = RawFileOperationSupport.nativeByteOrder();
        if (!fs.isValid(fd = fs.open(filename, RawFileOperationSupport.FileAccessMode.READ))) {
            log.string("unknown");
            return;
        }
        try {
            int bufferSize = 64;
            CCharPointer buffer = (CCharPointer)StackValue.get((int)bufferSize);
            long readBytes = fs.read(fd, (Pointer)buffer, Word.unsigned((int)bufferSize));
            int length = DumpLinuxOSInfo.countLineBytes(buffer, NumUtil.safeToInt((long)readBytes));
            log.string(buffer, length);
        }
        finally {
            fs.close(fd);
        }
    }

    private static int countLineBytes(CCharPointer buffer, int len) {
        for (int i = 0; i < len; ++i) {
            if (buffer.read(i) != 10) continue;
            return i;
        }
        return len;
    }
}

