/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.code.DynamicMethodAddressResolutionHeapSupport;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.imagelayer.ImageLayerSection;
import com.oracle.svm.core.os.AbstractImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.linux.LinuxLibCHelper;
import com.oracle.svm.core.posix.linux.ProcFSSupport;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.ThreadLocalRandom;
import jdk.graal.compiler.nodes.PauseNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class LinuxImageHeapProvider
extends AbstractImageHeapProvider {
    public static final CGlobalData<Pointer> MAGIC = CGlobalDataFactory.createWord((WordBase)Word.signed((long)ThreadLocalRandom.current().nextLong()));
    private static final CGlobalData<CCharPointer> PROC_SELF_MAPS = CGlobalDataFactory.createCString("/proc/self/maps");
    private static final SignedWord UNASSIGNED_FD = Word.signed((int)-1);
    private static final SignedWord CANNOT_OPEN_FD = Word.signed((int)-2);
    private static final SignedWord COPY_RELOCATIONS_IN_PROGRESS = Word.signed((int)-1);
    private static final CGlobalData<WordPointer> CACHED_IMAGE_FD = CGlobalDataFactory.createWord((WordBase)UNASSIGNED_FD);
    private static final CGlobalData<WordPointer> CACHED_IMAGE_HEAP_OFFSET = CGlobalDataFactory.createWord();
    private static final CGlobalData<WordPointer> CACHED_IMAGE_HEAP_RELOCATIONS = CGlobalDataFactory.createWord();
    private static final int MAX_PATHLEN = 4096;
    static final CGlobalData<WordPointer> CACHED_LAYERED_IMAGE_HEAP_ADDRESS_SPACE_SIZE = CGlobalDataFactory.createWord();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getLayeredImageHeapAddressSpaceSize() {
        Word currentValue = (Word)CACHED_LAYERED_IMAGE_HEAP_ADDRESS_SPACE_SIZE.get().read();
        if (currentValue.isNonNull()) {
            return currentValue;
        }
        int imageHeapOffset = Heap.getHeap().getImageHeapOffsetInAddressSpace();
        assert (imageHeapOffset >= 0);
        UnsignedWord size = Word.unsigned((int)imageHeapOffset);
        UnsignedWord granularity = VirtualMemoryProvider.get().getGranularity();
        assert (UnsignedUtils.isAMultiple(size, granularity));
        Pointer currentSection = ImageLayerSection.getInitialLayerSection().get();
        while (currentSection.isNonNull()) {
            Word heapBegin = (Word)currentSection.readWord(ImageLayerSection.getEntryOffset(ImageLayerSection.SectionEntries.HEAP_BEGIN));
            Word heapEnd = (Word)currentSection.readWord(ImageLayerSection.getEntryOffset(ImageLayerSection.SectionEntries.HEAP_END));
            size = size.add(LinuxImageHeapProvider.getImageHeapSizeInFile(heapBegin, heapEnd));
            size = UnsignedUtils.roundUp(size, granularity);
            currentSection = (Pointer)currentSection.readWord(ImageLayerSection.getEntryOffset(ImageLayerSection.SectionEntries.NEXT_SECTION));
        }
        CACHED_LAYERED_IMAGE_HEAP_ADDRESS_SPACE_SIZE.get().write((WordBase)size);
        return size;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getImageHeapAddressSpaceSize() {
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            return LinuxImageHeapProvider.getLayeredImageHeapAddressSpaceSize();
        }
        return super.getImageHeapAddressSpaceSize();
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    protected int initializeLayeredImage(Pointer firstHeapStart, Pointer selfReservedHeapBase, UnsignedWord initialRemainingSize, WordPointer endPointer) {
        int result = -1;
        UnsignedWord remainingSize = initialRemainingSize;
        int layerCount = 0;
        Pointer currentSection = ImageLayerSection.getInitialLayerSection().get();
        Pointer currentHeapStart = firstHeapStart;
        WordPointer curEndPointer = endPointer;
        if (endPointer.isNull()) {
            curEndPointer = (WordPointer)StackValue.get(WordPointer.class);
        }
        while (currentSection.isNonNull()) {
            WordPointer cachedFDPointer = ImageLayerSection.getCachedImageFDs().get().addressOf(layerCount);
            WordPointer cachedOffsetsPointer = ImageLayerSection.getCachedImageHeapOffsets().get().addressOf(layerCount);
            WordPointer cachedImageHeapRelocationsPtr = ImageLayerSection.getCachedImageHeapRelocations().get().addressOf(layerCount);
            Word heapBegin = (Word)currentSection.readWord(ImageLayerSection.getEntryOffset(ImageLayerSection.SectionEntries.HEAP_BEGIN));
            Word heapEnd = (Word)currentSection.readWord(ImageLayerSection.getEntryOffset(ImageLayerSection.SectionEntries.HEAP_END));
            Word heapRelocBegin = (Word)currentSection.readWord(ImageLayerSection.getEntryOffset(ImageLayerSection.SectionEntries.HEAP_RELOCATABLE_BEGIN));
            Word heapRelocEnd = (Word)currentSection.readWord(ImageLayerSection.getEntryOffset(ImageLayerSection.SectionEntries.HEAP_RELOCATABLE_END));
            Word heapAnyRelocPointer = (Word)Word.nullPointer();
            Word heapWritableBegin = (Word)currentSection.readWord(ImageLayerSection.getEntryOffset(ImageLayerSection.SectionEntries.HEAP_WRITEABLE_BEGIN));
            Word heapWritableEnd = (Word)currentSection.readWord(ImageLayerSection.getEntryOffset(ImageLayerSection.SectionEntries.HEAP_WRITEABLE_END));
            Word heapWritablePatchedBegin = (Word)currentSection.readWord(ImageLayerSection.getEntryOffset(ImageLayerSection.SectionEntries.HEAP_WRITEABLE_PATCHED_BEGIN));
            Word heapWritablePatchedEnd = (Word)currentSection.readWord(ImageLayerSection.getEntryOffset(ImageLayerSection.SectionEntries.HEAP_WRITEABLE_PATCHED_END));
            result = LinuxImageHeapProvider.initializeImageHeap(currentHeapStart, remainingSize, curEndPointer, cachedFDPointer, cachedOffsetsPointer, cachedImageHeapRelocationsPtr, MAGIC.get(), heapBegin, heapEnd, heapRelocBegin, (Pointer)heapAnyRelocPointer, heapRelocEnd, heapWritablePatchedBegin, heapWritablePatchedEnd, heapWritableBegin, heapWritableEnd);
            if (result != 0) {
                this.freeImageHeap((PointerBase)selfReservedHeapBase);
                return result;
            }
            Pointer newHeapStart = (Pointer)curEndPointer.read();
            remainingSize = remainingSize.subtract((UnsignedWord)newHeapStart.subtract((UnsignedWord)currentHeapStart));
            currentHeapStart = newHeapStart;
            currentSection = (Pointer)currentSection.readWord(ImageLayerSection.getEntryOffset(ImageLayerSection.SectionEntries.NEXT_SECTION));
            ++layerCount;
        }
        return result;
    }

    @Override
    @Uninterruptible(reason="Called during isolate initialization.")
    public int initialize(Pointer reservedAddressSpace, UnsignedWord reservedSize, WordPointer basePointer, WordPointer endPointer) {
        Pointer heapBase;
        Pointer selfReservedHeapBase;
        Pointer selfReservedMemory = (Pointer)Word.nullPointer();
        UnsignedWord requiredSize = this.getTotalRequiredAddressSpaceSize();
        if (reservedAddressSpace.isNull()) {
            UnsignedWord alignment = Word.unsigned((int)Heap.getHeap().getPreferredAddressSpaceAlignment());
            selfReservedMemory = VirtualMemoryProvider.get().reserve(requiredSize, alignment, false);
            if (selfReservedMemory.isNull()) {
                return 801;
            }
        } else if (reservedSize.belowThan(requiredSize)) {
            return 802;
        }
        UnsignedWord remainingSize = requiredSize;
        if (DynamicMethodAddressResolutionHeapSupport.isEnabled()) {
            UnsignedWord preHeapRequiredBytes = LinuxImageHeapProvider.getPreHeapAlignedSizeForDynamicMethodAddressResolver();
            if (selfReservedMemory.isNonNull()) {
                heapBase = selfReservedHeapBase = selfReservedMemory.add(preHeapRequiredBytes);
            } else {
                heapBase = reservedAddressSpace.add(preHeapRequiredBytes);
                selfReservedHeapBase = (Pointer)Word.nullPointer();
            }
            remainingSize = remainingSize.subtract(preHeapRequiredBytes);
            int error = DynamicMethodAddressResolutionHeapSupport.get().initialize();
            if (error != 0) {
                this.freeImageHeap((PointerBase)selfReservedHeapBase);
                return error;
            }
            error = DynamicMethodAddressResolutionHeapSupport.get().install(heapBase);
            if (error != 0) {
                this.freeImageHeap((PointerBase)selfReservedHeapBase);
                return error;
            }
        } else {
            heapBase = selfReservedMemory.isNonNull() ? selfReservedMemory : reservedAddressSpace;
            selfReservedHeapBase = selfReservedMemory;
        }
        int imageHeapOffsetInAddressSpace = Heap.getHeap().getImageHeapOffsetInAddressSpace();
        basePointer.write((WordBase)heapBase);
        Pointer imageHeapStart = heapBase.add(imageHeapOffsetInAddressSpace);
        remainingSize = remainingSize.subtract(imageHeapOffsetInAddressSpace);
        if (!ImageLayerBuildingSupport.buildingImageLayer()) {
            int result = LinuxImageHeapProvider.initializeImageHeap(imageHeapStart, remainingSize, endPointer, CACHED_IMAGE_FD.get(), CACHED_IMAGE_HEAP_OFFSET.get(), CACHED_IMAGE_HEAP_RELOCATIONS.get(), MAGIC.get(), Isolates.IMAGE_HEAP_BEGIN.get(), Isolates.IMAGE_HEAP_END.get(), Isolates.IMAGE_HEAP_RELOCATABLE_BEGIN.get(), (Pointer)Isolates.IMAGE_HEAP_A_RELOCATABLE_POINTER.get(), Isolates.IMAGE_HEAP_RELOCATABLE_END.get(), Isolates.IMAGE_HEAP_WRITABLE_PATCHED_BEGIN.get(), Isolates.IMAGE_HEAP_WRITABLE_PATCHED_END.get(), Isolates.IMAGE_HEAP_WRITABLE_BEGIN.get(), Isolates.IMAGE_HEAP_WRITABLE_END.get());
            if (result != 0) {
                this.freeImageHeap((PointerBase)selfReservedHeapBase);
            }
            return result;
        }
        return this.initializeLayeredImage(imageHeapStart, selfReservedHeapBase, remainingSize, endPointer);
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    private static int initializeImageHeap(Pointer imageHeap, UnsignedWord reservedSize, WordPointer endPointer, WordPointer cachedFd, WordPointer cachedOffsetInFile, WordPointer cachedImageHeapRelocationsPtr, Pointer magicAddress, Word heapBeginSym, Word heapEndSym, Word heapRelocsSym, Pointer heapAnyRelocPointer, Word heapRelocsEndSym, Word heapWritablePatchedSym, Word heapWritablePatchedEndSym, Word heapWritableSym, Word heapWritableEndSym) {
        assert (heapBeginSym.belowOrEqual(heapWritableSym) && heapWritableSym.belowOrEqual(heapWritableEndSym) && heapWritableEndSym.belowOrEqual(heapEndSym));
        assert (heapBeginSym.belowOrEqual(heapRelocsSym) && heapRelocsSym.belowOrEqual(heapRelocsEndSym) && heapRelocsEndSym.belowOrEqual(heapEndSym));
        assert (ImageLayerBuildingSupport.buildingImageLayer() || heapRelocsSym.belowOrEqual((UnsignedWord)heapAnyRelocPointer) && heapAnyRelocPointer.belowThan((UnsignedWord)heapRelocsEndSym));
        assert (heapRelocsSym.belowOrEqual(heapRelocsEndSym) && heapRelocsEndSym.belowOrEqual(heapWritablePatchedSym) && heapWritablePatchedSym.belowOrEqual(heapWritableEndSym));
        SignedWord fd = (SignedWord)cachedFd.read();
        if (fd.equal(UNASSIGNED_FD)) {
            int opened = LinuxImageHeapProvider.openImageFile(heapBeginSym, magicAddress, cachedOffsetInFile);
            SignedWord previous = (SignedWord)((Pointer)cachedFd).compareAndSwapWord(0, (WordBase)fd, (WordBase)Word.signed((int)opened), LocationIdentity.ANY_LOCATION);
            if (previous.equal(fd)) {
                fd = Word.signed((int)opened);
            } else {
                if (opened >= 0) {
                    Unistd.NoTransitions.close(opened);
                }
                fd = previous;
            }
        }
        UnsignedWord pageSize = VirtualMemoryProvider.get().getGranularity();
        UnsignedWord imageHeapSize = LinuxImageHeapProvider.getImageHeapSizeInFile(heapBeginSym, heapEndSym);
        assert (reservedSize.aboveOrEqual(imageHeapSize));
        if (endPointer.isNonNull()) {
            endPointer.write((WordBase)UnsignedUtils.roundUp((UnsignedWord)imageHeap.add(imageHeapSize), pageSize));
        }
        if (fd.equal(CANNOT_OPEN_FD)) {
            int result = LinuxImageHeapProvider.initializeImageHeapWithMremap(imageHeap, imageHeapSize, pageSize, cachedImageHeapRelocationsPtr, heapBeginSym, heapRelocsSym, heapAnyRelocPointer, heapRelocsEndSym, heapWritablePatchedSym, heapWritablePatchedEndSym, heapWritableSym, heapWritableEndSym);
            if (result == 803) {
                return LinuxImageHeapProvider.initializeImageHeapByCopying(imageHeap, imageHeapSize, pageSize, heapBeginSym, heapWritableSym, heapWritableEndSym);
            }
            return result;
        }
        UnsignedWord fileOffset = (UnsignedWord)cachedOffsetInFile.read();
        Pointer mappedImageHeap = VirtualMemoryProvider.get().mapFile((PointerBase)imageHeap, imageHeapSize, (WordBase)fd, fileOffset, 1);
        if (mappedImageHeap.isNull() || mappedImageHeap != imageHeap) {
            return 8;
        }
        int result = LinuxImageHeapProvider.copyRelocations(imageHeap, pageSize, heapBeginSym, heapRelocsSym, heapAnyRelocPointer, heapRelocsEndSym, heapWritablePatchedSym, heapWritablePatchedEndSym, (Pointer)Word.nullPointer());
        if (result != 0) {
            return result;
        }
        return LinuxImageHeapProvider.unprotectWritablePages(imageHeap, pageSize, heapBeginSym, heapWritableSym, heapWritableEndSym);
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    private static int initializeImageHeapWithMremap(Pointer imageHeap, UnsignedWord imageHeapSizeInFile, UnsignedWord pageSize, WordPointer cachedImageHeapRelocationsPtr, Word heapBeginSym, Word heapRelocsSym, Pointer heapAnyRelocPointer, Word heapRelocsEndSym, Word heapWritablePatchedSym, Word heapWritablePatchedEndSym, Word heapWritableSym, Word heapWritableEndSym) {
        if (!SubstrateOptions.MremapImageHeap.getValue().booleanValue()) {
            return 803;
        }
        Pointer cachedImageHeapRelocations = LinuxImageHeapProvider.getCachedImageHeapRelocations((Pointer)cachedImageHeapRelocationsPtr, pageSize, heapRelocsSym, heapWritablePatchedEndSym);
        assert (cachedImageHeapRelocations.notEqual(0));
        if (cachedImageHeapRelocations.rawValue() < 0L) {
            return (int)(-cachedImageHeapRelocations.rawValue());
        }
        int mremapFlags = LinuxLibCHelper.MREMAP_FIXED() | LinuxLibCHelper.MREMAP_MAYMOVE() | LinuxLibCHelper.MREMAP_DONTUNMAP();
        Pointer res = LinuxLibCHelper.NoTransitions.mremapP((PointerBase)heapBeginSym, imageHeapSizeInFile, imageHeapSizeInFile, mremapFlags, (PointerBase)imageHeap);
        if (res.notEqual((ComparableWord)imageHeap)) {
            return 8;
        }
        int result = LinuxImageHeapProvider.copyRelocations(imageHeap, pageSize, heapBeginSym, heapRelocsSym, heapAnyRelocPointer, heapRelocsEndSym, heapWritablePatchedSym, heapWritablePatchedEndSym, cachedImageHeapRelocations);
        if (result != 0) {
            return result;
        }
        if (VirtualMemoryProvider.get().protect((PointerBase)imageHeap, imageHeapSizeInFile, 1) != 0) {
            return 9;
        }
        return LinuxImageHeapProvider.unprotectWritablePages(imageHeap, pageSize, heapBeginSym, heapWritableSym, heapWritableEndSym);
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    private static Pointer getCachedImageHeapRelocations(Pointer cachedImageHeapRelocationsPtr, UnsignedWord pageSize, Word heapRelocsSym, Word heapWritablePatchedEndSym) {
        Pointer imageHeapRelocations = (Pointer)cachedImageHeapRelocationsPtr.readWord(0, LocationIdentity.ANY_LOCATION);
        if (imageHeapRelocations.isNull() || imageHeapRelocations.equal((ComparableWord)COPY_RELOCATIONS_IN_PROGRESS)) {
            if (!cachedImageHeapRelocationsPtr.logicCompareAndSwapWord(0, (WordBase)Word.nullPointer(), (WordBase)COPY_RELOCATIONS_IN_PROGRESS, LocationIdentity.ANY_LOCATION)) {
                while ((imageHeapRelocations = (Pointer)cachedImageHeapRelocationsPtr.readWordVolatile(0, LocationIdentity.ANY_LOCATION)).equal((ComparableWord)COPY_RELOCATIONS_IN_PROGRESS)) {
                    PauseNode.pause();
                }
            } else {
                int mremapFlags;
                UnsignedWord heapRelocsLength;
                Pointer linkedRelocsBoundary = PointerUtils.roundDown((PointerBase)heapRelocsSym, pageSize);
                imageHeapRelocations = LinuxLibCHelper.NoTransitions.mremapP((PointerBase)linkedRelocsBoundary, heapRelocsLength = UnsignedUtils.roundUp((UnsignedWord)heapWritablePatchedEndSym.subtract((UnsignedWord)linkedRelocsBoundary), pageSize), heapRelocsLength, mremapFlags = LinuxLibCHelper.MREMAP_MAYMOVE() | LinuxLibCHelper.MREMAP_DONTUNMAP(), Word.nullPointer());
                if (imageHeapRelocations.equal(-1)) {
                    imageHeapRelocations = LibC.errno() == Errno.EINVAL() ? (Pointer)Word.pointer((long)-803L) : (Pointer)Word.pointer((long)-8L);
                } else if (VirtualMemoryProvider.get().protect((PointerBase)imageHeapRelocations, heapRelocsLength, 1) != 0) {
                    imageHeapRelocations = (Pointer)Word.pointer((long)-9L);
                }
                cachedImageHeapRelocationsPtr.writeWordVolatile(0, (WordBase)imageHeapRelocations);
            }
        }
        assert (imageHeapRelocations.isNonNull() && imageHeapRelocations.notEqual((ComparableWord)COPY_RELOCATIONS_IN_PROGRESS));
        return imageHeapRelocations;
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    private static int copyRelocations(Pointer imageHeap, UnsignedWord pageSize, Word heapBeginSym, Word heapRelocsSym, Pointer heapAnyRelocPointer, Word heapRelocsEndSym, Word heapWritablePatchedSym, Word heapWritablePatchedEndSym, Pointer cachedRelocsBoundary) {
        Pointer linkedRelocsBoundary = PointerUtils.roundDown((PointerBase)heapRelocsSym, pageSize);
        Pointer sourceRelocsBoundary = cachedRelocsBoundary.isNonNull() ? cachedRelocsBoundary : linkedRelocsBoundary;
        Pointer linkedCopyStart = (Pointer)Word.nullPointer();
        if (heapRelocsEndSym.subtract(heapRelocsSym).isNonNull()) {
            boolean copyRequired;
            if (ImageLayerBuildingSupport.buildingImageLayer()) {
                assert (heapAnyRelocPointer.isNull());
                copyRequired = true;
            } else {
                ComparableWord relocatedValue = (ComparableWord)sourceRelocsBoundary.readWord((WordBase)heapAnyRelocPointer.subtract((UnsignedWord)linkedRelocsBoundary));
                ComparableWord mappedValue = (ComparableWord)imageHeap.readWord((WordBase)heapAnyRelocPointer.subtract((UnsignedWord)heapBeginSym));
                copyRequired = relocatedValue.notEqual(mappedValue);
            }
            if (copyRequired) {
                linkedCopyStart = heapRelocsSym;
            }
        }
        if (linkedCopyStart.isNull() && heapWritablePatchedEndSym.subtract(heapWritablePatchedSym).isNonNull()) {
            linkedCopyStart = heapWritablePatchedSym;
        }
        if (linkedCopyStart.isNonNull()) {
            Pointer linkedCopyStartBoundary = PointerUtils.roundDown((PointerBase)linkedCopyStart, pageSize);
            UnsignedWord copyAlignedSize = UnsignedUtils.roundUp((UnsignedWord)heapWritablePatchedEndSym.subtract((UnsignedWord)linkedCopyStartBoundary), pageSize);
            Pointer destCopyStartBoundary = imageHeap.add((UnsignedWord)linkedCopyStartBoundary.subtract((UnsignedWord)heapBeginSym));
            Pointer committedCopyBegin = VirtualMemoryProvider.get().commit((PointerBase)destCopyStartBoundary, copyAlignedSize, 3);
            if (committedCopyBegin.isNull() || committedCopyBegin != destCopyStartBoundary) {
                return 9;
            }
            Pointer sourceCopyStartBoundary = sourceRelocsBoundary.add((UnsignedWord)linkedCopyStartBoundary.subtract((UnsignedWord)linkedRelocsBoundary));
            LibC.memcpy(destCopyStartBoundary, (PointerBase)sourceCopyStartBoundary, copyAlignedSize);
            if (linkedRelocsBoundary.belowOrEqual((UnsignedWord)heapRelocsEndSym) && heapRelocsEndSym.subtract(heapRelocsSym).isNonNull()) {
                UnsignedWord relocsAlignedSize = UnsignedUtils.roundUp((UnsignedWord)heapRelocsEndSym.subtract((UnsignedWord)linkedRelocsBoundary), pageSize);
                if (VirtualMemoryProvider.get().protect((PointerBase)destCopyStartBoundary, relocsAlignedSize, 1) != 0) {
                    return 9;
                }
            }
        }
        return 0;
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    private static int unprotectWritablePages(Pointer imageHeap, UnsignedWord pageSize, Word heapBeginSym, Word heapWritableSym, Word heapWritableEndSym) {
        Pointer writableBegin = imageHeap.add((UnsignedWord)heapWritableSym.subtract(heapBeginSym));
        Word writableSize = heapWritableEndSym.subtract(heapWritableSym);
        UnsignedWord alignedWritableSize = UnsignedUtils.roundUp((UnsignedWord)writableSize, pageSize);
        if (VirtualMemoryProvider.get().protect((PointerBase)writableBegin, alignedWritableSize, 3) != 0) {
            return 9;
        }
        return 0;
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    private static int initializeImageHeapByCopying(Pointer imageHeap, UnsignedWord imageHeapSize, UnsignedWord pageSize, Word heapBeginSym, Word heapWritableSym, Word heapWritableEndSym) {
        Pointer committedBegin = VirtualMemoryProvider.get().commit((PointerBase)imageHeap, imageHeapSize, 3);
        if (committedBegin.isNull()) {
            return 8;
        }
        LibC.memcpy(imageHeap, (PointerBase)heapBeginSym, imageHeapSize);
        Word readOnlyBytesAtBegin = heapWritableSym.subtract(heapBeginSym);
        readOnlyBytesAtBegin = UnsignedUtils.roundDown((UnsignedWord)readOnlyBytesAtBegin, pageSize);
        if (readOnlyBytesAtBegin.aboveThan(0) && VirtualMemoryProvider.get().protect((PointerBase)imageHeap, (UnsignedWord)readOnlyBytesAtBegin, 1) != 0) {
            return 9;
        }
        Pointer writableEnd = imageHeap.add((UnsignedWord)heapWritableEndSym.subtract(heapBeginSym));
        writableEnd = PointerUtils.roundUp((PointerBase)writableEnd, pageSize);
        Pointer readOnlyBytesAtEnd = imageHeap.add(imageHeapSize).subtract((UnsignedWord)writableEnd);
        if ((readOnlyBytesAtEnd = UnsignedUtils.roundUp((UnsignedWord)readOnlyBytesAtEnd, pageSize)).aboveThan(0) && VirtualMemoryProvider.get().protect((PointerBase)writableEnd, (UnsignedWord)readOnlyBytesAtEnd, 1) != 0) {
            return 9;
        }
        return 0;
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    private static int openImageFile(Word heapBeginSym, Pointer magicAddress, WordPointer cachedImageHeapOffsetInFile) {
        int failfd = (int)CANNOT_OPEN_FD.rawValue();
        int mapfd = Fcntl.NoTransitions.open(PROC_SELF_MAPS.get(), Fcntl.O_RDONLY(), 0);
        if (mapfd == -1) {
            return failfd;
        }
        int bufferSize = 4096;
        CCharPointer buffer = (CCharPointer)StackValue.get((int)4096);
        WordPointer imageHeapMappingStart = (WordPointer)StackValue.get(WordPointer.class);
        WordPointer imageHeapMappingFileOffset = (WordPointer)StackValue.get(WordPointer.class);
        boolean found = ProcFSSupport.findMapping(mapfd, buffer, 4096, (UnsignedWord)heapBeginSym, (UnsignedWord)heapBeginSym.add(1), imageHeapMappingStart, imageHeapMappingFileOffset, true);
        if (!found) {
            Unistd.NoTransitions.close(mapfd);
            return failfd;
        }
        int opened = Fcntl.NoTransitions.open(buffer, Fcntl.O_RDONLY(), 0);
        if (opened < 0) {
            Unistd.NoTransitions.close(mapfd);
            return failfd;
        }
        boolean valid = magicAddress.isNull() || LinuxImageHeapProvider.checkImageFileMagic(mapfd, opened, buffer, 4096, magicAddress);
        Unistd.NoTransitions.close(mapfd);
        if (!valid) {
            Unistd.NoTransitions.close(opened);
            return failfd;
        }
        Word imageHeapOffsetInMapping = heapBeginSym.subtract((Word)imageHeapMappingStart.read());
        Word imageHeapOffsetInFile = imageHeapOffsetInMapping.add((Word)imageHeapMappingFileOffset.read());
        cachedImageHeapOffsetInFile.write((WordBase)imageHeapOffsetInFile);
        return opened;
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    private static boolean checkImageFileMagic(int mapfd, int imagefd, CCharPointer buffer, int bufferSize, Pointer magicAddress) {
        if (Unistd.NoTransitions.lseek(mapfd, Word.signed((int)0), Unistd.SEEK_SET()).notEqual(0)) {
            return false;
        }
        int wordSize = ConfigurationValues.getTarget().wordSize;
        WordPointer magicMappingStart = (WordPointer)StackValue.get(WordPointer.class);
        WordPointer magicMappingFileOffset = (WordPointer)StackValue.get(WordPointer.class);
        boolean found = ProcFSSupport.findMapping(mapfd, buffer, bufferSize, (UnsignedWord)magicAddress, (UnsignedWord)magicAddress.add(wordSize), magicMappingStart, magicMappingFileOffset, false);
        if (!found) {
            return false;
        }
        Word magicFileOffset = (Word)magicAddress.subtract((UnsignedWord)magicMappingStart.read()).add((UnsignedWord)magicMappingFileOffset.read());
        if (Unistd.NoTransitions.lseek(imagefd, (SignedWord)magicFileOffset, Unistd.SEEK_SET()).notEqual((SignedWord)magicFileOffset)) {
            return false;
        }
        if (PosixUtils.readUninterruptibly(imagefd, (Pointer)buffer, wordSize) != wordSize) {
            return false;
        }
        Word fileMagic = (Word)((WordPointer)buffer).read();
        return fileMagic.equal((Word)magicAddress.readWord(0));
    }

    @Override
    @Uninterruptible(reason="Called during isolate tear-down.")
    public int freeImageHeap(PointerBase heapBase) {
        if (heapBase.isNull()) {
            return 0;
        }
        VMError.guarantee(heapBase.notEqual((ComparableWord)Isolates.IMAGE_HEAP_BEGIN.get()), "reusing the image heap is no longer supported");
        Pointer addressSpaceStart = (Pointer)heapBase;
        if (DynamicMethodAddressResolutionHeapSupport.isEnabled()) {
            addressSpaceStart = addressSpaceStart.subtract(LinuxImageHeapProvider.getPreHeapAlignedSizeForDynamicMethodAddressResolver());
        }
        if (VirtualMemoryProvider.get().free((PointerBase)addressSpaceStart, this.getTotalRequiredAddressSpaceSize()) != 0) {
            return 20;
        }
        return 0;
    }
}

