/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.reflect.target.Target_jdk_internal_reflect_ConstantPool;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.RecordComponent;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public interface RuntimeMetadataDecoder {
    public static final int NO_DATA = -1;

    public Field[] parseFields(DynamicHub var1, int var2, boolean var3, int var4);

    public FieldDescriptor[] parseReachableFields(DynamicHub var1, int var2, int var3);

    public Method[] parseMethods(DynamicHub var1, int var2, boolean var3, int var4);

    public MethodDescriptor[] parseReachableMethods(DynamicHub var1, int var2, int var3);

    public Constructor<?>[] parseConstructors(DynamicHub var1, int var2, boolean var3, int var4);

    public ConstructorDescriptor[] parseReachableConstructors(DynamicHub var1, int var2, int var3);

    public Class<?>[] parseClasses(int var1, DynamicHub var2);

    public Class<?>[] parseAllClasses();

    public RecordComponent[] parseRecordComponents(DynamicHub var1, int var2, int var3);

    public Object[] parseObjects(int var1, DynamicHub var2);

    public Parameter[] parseReflectParameters(Executable var1, byte[] var2, DynamicHub var3);

    public Object[] parseEnclosingMethod(int var1, DynamicHub var2);

    public byte[] parseByteArray(int var1, DynamicHub var2);

    public boolean isHiding(int var1);

    public boolean isNegative(int var1);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public int getMetadataByteLength();

    public static int getConstantPoolLayerId(Target_jdk_internal_reflect_ConstantPool constPool) {
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            return constPool.getLayerId();
        }
        return 0;
    }

    public static interface MetadataAccessor {
        @Fold
        public static MetadataAccessor singleton() {
            return (MetadataAccessor)ImageSingletons.lookup(MetadataAccessor.class);
        }

        public <T> T getObject(int var1, int var2);

        public Class<?> getClass(int var1, int var2);

        public String getMemberName(int var1, int var2);

        public String getOtherString(int var1, int var2);
    }

    public static class ConstructorDescriptor
    extends ElementDescriptor {
        public final String[] parameterTypeNames;

        public ConstructorDescriptor(Class<?> declaringClass, String[] parameterTypeNames) {
            super(declaringClass);
            this.parameterTypeNames = parameterTypeNames;
        }

        public ConstructorDescriptor(Constructor<?> constructor) {
            this(constructor.getDeclaringClass(), ConstructorDescriptor.getParameterTypeNames(constructor.getParameterTypes()));
        }

        public String[] getParameterTypeNames() {
            return this.parameterTypeNames;
        }
    }

    public static class MethodDescriptor
    extends ElementDescriptor {
        public final String name;
        public final String[] parameterTypeNames;

        public MethodDescriptor(Class<?> declaringClass, String name, String[] parameterTypeNames) {
            super(declaringClass);
            this.name = name;
            this.parameterTypeNames = parameterTypeNames;
        }

        public MethodDescriptor(Method method) {
            this(method.getDeclaringClass(), method.getName(), MethodDescriptor.getParameterTypeNames(method.getParameterTypes()));
        }

        public String getName() {
            return this.name;
        }

        public String[] getParameterTypeNames() {
            return this.parameterTypeNames;
        }
    }

    public static class FieldDescriptor
    extends ElementDescriptor {
        public final String name;

        public FieldDescriptor(Class<?> declaringClass, String name) {
            super(declaringClass);
            this.name = name;
        }

        public FieldDescriptor(Field field) {
            this(field.getDeclaringClass(), field.getName());
        }

        public String getName() {
            return this.name;
        }
    }

    public static class ElementDescriptor {
        private final Class<?> declaringClass;

        public ElementDescriptor(Class<?> declaringClass) {
            this.declaringClass = declaringClass;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        protected static String[] getParameterTypeNames(Class<?>[] parameterTypes) {
            String[] parameterTypeNames = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterTypeNames[i] = parameterTypes[i].getTypeName();
            }
            return parameterTypeNames;
        }
    }
}

