/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.interpreter.InterpreterSupport;
import com.oracle.svm.core.stack.JavaFrame;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class JavaFrames {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isUnknownFrame(JavaFrame frame) {
        return frame.getIPCodeInfo().isNull() && Deoptimizer.checkEagerDeoptimized(frame) == null;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isEntryPoint(JavaFrame frame) {
        return CodeInfoQueryResult.isEntryPoint(frame.getEncodedFrameSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isInterpreterLeaveStub(JavaFrame frame) {
        if (!InterpreterSupport.isEnabled()) {
            return false;
        }
        return InterpreterSupport.isInInterpreterLeaveStub(frame.getIP());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getTotalFrameSize(JavaFrame frame) {
        long size = CodeInfoQueryResult.getTotalFrameSize(frame.getEncodedFrameSize());
        assert (size > 0L);
        return Word.unsigned((long)size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getCallerSP(JavaFrame frame) {
        assert (frame.getSP().isNonNull());
        return frame.getSP().add(JavaFrames.getTotalFrameSize(frame));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void clearData(JavaFrame frame) {
        frame.setSP((Pointer)Word.nullPointer());
        frame.setIP((CodePointer)Word.nullPointer());
        frame.setIPCodeInfo((UntetheredCodeInfo)Word.nullPointer());
        frame.setIsPendingLazyDeopt(false);
        frame.setEncodedFrameSize(0L);
        frame.setExceptionOffset(0L);
        frame.setReferenceMapIndex(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent deoptimization and GC.", callerMustBe=true)
    public static void setData(JavaFrame frame, Pointer sp, CodePointer ip) {
        frame.setSP(sp);
        frame.setIP(ip);
        frame.setIsPendingLazyDeopt(false);
        DeoptimizedFrame deoptimizedFrame = Deoptimizer.checkEagerDeoptimized(frame);
        if (deoptimizedFrame != null) {
            frame.setIPCodeInfo((UntetheredCodeInfo)Word.nullPointer());
            frame.setEncodedFrameSize(deoptimizedFrame.getSourceEncodedFrameSize());
            frame.setExceptionOffset(0L);
            frame.setReferenceMapIndex(-1L);
        } else {
            CodePointer returnAddress = ip;
            if (Deoptimizer.checkLazyDeoptimized(ip)) {
                frame.setIsPendingLazyDeopt(true);
                returnAddress = (CodePointer)sp.readWord(0);
                assert (returnAddress.isNonNull());
                frame.setIP(returnAddress);
            }
            UntetheredCodeInfo untetheredCodeInfo = CodeInfoTable.lookupCodeInfo(returnAddress);
            frame.setIPCodeInfo(untetheredCodeInfo);
            if (untetheredCodeInfo.isNull()) {
                frame.setEncodedFrameSize(0L);
                frame.setExceptionOffset(0L);
                frame.setReferenceMapIndex(-1L);
            } else {
                Object tether = CodeInfoAccess.acquireTether(untetheredCodeInfo);
                try {
                    CodeInfo info = CodeInfoAccess.convert(untetheredCodeInfo, tether);
                    CodeInfoAccess.lookupCodeInfo(info, returnAddress, frame);
                }
                finally {
                    CodeInfoAccess.releaseTether(untetheredCodeInfo, tether);
                }
            }
        }
    }
}

