/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.Jvm;
import com.oracle.svm.core.windows.WindowsUtils;
import java.io.Console;
import java.util.Objects;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.type.VoidPointer;

@TargetClass(value=System.class)
final class Target_java_lang_System {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    static volatile Console cons;

    Target_java_lang_System() {
    }

    @Substitute
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static long nanoTime() {
        return WindowsUtils.getNanoCounter();
    }

    @Substitute
    public static String mapLibraryName(String libname) {
        Objects.requireNonNull(libname);
        return libname + ".dll";
    }

    @Substitute
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long currentTimeMillis() {
        return Jvm.JVM_CurrentTimeMillis((VoidPointer)Word.nullPointer(), (VoidPointer)Word.nullPointer());
    }
}

