/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.pltgot;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.NonSnippetLowerings;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.pltgot.GOTAccess;
import com.oracle.svm.graal.pltgot.SubstrateGOTCallTargetNode;
import com.oracle.svm.hosted.nodes.ReadReservedRegister;
import com.oracle.svm.hosted.pltgot.GOTEntryAllocator;
import com.oracle.svm.hosted.pltgot.HostedPLTGOTConfiguration;
import com.oracle.svm.hosted.pltgot.MethodAddressResolutionSupport;
import java.util.Map;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LoweredCallTargetNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class PLTGOTNonSnippetLowerings {
    public static void registerLowerings(RuntimeConfiguration runtimeConfig, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        InvokeThroughGOTLowering invokeLowering = new InvokeThroughGOTLowering(runtimeConfig);
        lowerings.put(InvokeNode.class, invokeLowering);
        lowerings.put(InvokeWithExceptionNode.class, invokeLowering);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final class InvokeThroughGOTLowering
    extends NonSnippetLowerings.InvokeLowering {
        private final MethodAddressResolutionSupport methodAddressResolutionSupport = HostedPLTGOTConfiguration.singleton().getMethodAddressResolutionSupport();
        private final GOTEntryAllocator gotEntryAllocator = HostedPLTGOTConfiguration.singleton().getGOTEntryAllocator();

        InvokeThroughGOTLowering(RuntimeConfiguration runtimeConfig) {
            super(runtimeConfig, SubstrateOptions.VerifyTypes.getValue(), KnownOffsets.singleton());
        }

        @Override
        protected LoweredCallTargetNode createDirectCall(StructuredGraph graph, MethodCallTargetNode callTarget, NodeInputList<ValueNode> parameters, JavaType[] signature, CallingConvention.Type callType, CallTargetNode.InvokeKind invokeKind, SharedMethod callee, FixedNode node) {
            SharedMethod caller = (SharedMethod)graph.method();
            if (this.methodAddressResolutionSupport.shouldCallViaPLTGOT(caller, callee)) {
                ValueNode heapBaseNode = (ValueNode)graph.addOrUnique((Node)ReadReservedRegister.createReadHeapBaseNode(graph));
                int targetGotEntry = this.gotEntryAllocator.getMethodGotEntry(callee);
                ConstantNode offsetNode = ConstantNode.forIntegerKind((JavaKind)ConfigurationValues.getWordKind(), (long)GOTAccess.getGotEntryOffsetFromHeapRegister(targetGotEntry), (StructuredGraph)graph);
                OffsetAddressNode offsetAddressNode = (OffsetAddressNode)graph.unique((Node)new OffsetAddressNode(heapBaseNode, (ValueNode)offsetNode));
                ReadNode methodAddress = (ReadNode)graph.add((Node)new ReadNode((AddressNode)offsetAddressNode, LocationIdentity.ANY_LOCATION, FrameAccess.getWordStamp(), BarrierType.NONE, MemoryOrderMode.PLAIN));
                SubstrateGOTCallTargetNode loweredCallTarget = (SubstrateGOTCallTargetNode)graph.add((Node)new SubstrateGOTCallTargetNode((ValueNode)methodAddress, (ValueNode[])parameters.toArray((Object[])ValueNode.EMPTY_ARRAY), callTarget.returnStamp(), signature, callee, callType, invokeKind));
                graph.addBeforeFixed(node, (FixedWithNextNode)methodAddress);
                return loweredCallTarget;
            }
            return super.createDirectCall(graph, callTarget, parameters, signature, callType, invokeKind, callee, node);
        }

        @Override
        protected IndirectCallTargetNode createIndirectCall(StructuredGraph graph, MethodCallTargetNode callTarget, NodeInputList<ValueNode> parameters, SharedMethod callee, JavaType[] signature, CallingConvention.Type callType, CallTargetNode.InvokeKind invokeKind, ValueNode entry) {
            SharedMethod caller = (SharedMethod)graph.method();
            if (this.methodAddressResolutionSupport.shouldCallViaPLTGOT(caller, callee)) {
                for (SharedMethod implementation : callee.getImplementations()) {
                    this.gotEntryAllocator.reserveMethodGotEntry(implementation);
                }
            }
            return super.createIndirectCall(graph, callTarget, parameters, callee, signature, callType, invokeKind, entry);
        }
    }
}

