/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.info;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.c.enums.CEnumRuntimeData;
import com.oracle.svm.hosted.c.info.InfoTreeVisitor;
import com.oracle.svm.hosted.c.info.SizableInfo;
import java.util.ArrayList;
import jdk.vm.ci.meta.ResolvedJavaType;

public class EnumInfo
extends SizableInfo {
    private final ResolvedJavaType annotatedType;
    private final ArrayList<AnalysisMethod> valueMethods = new ArrayList();
    private final ArrayList<AnalysisMethod> lookupMethods = new ArrayList();
    private CEnumRuntimeData runtimeData;

    public EnumInfo(String name, ResolvedJavaType annotatedType) {
        super(name, SizableInfo.ElementKind.INTEGER);
        this.annotatedType = annotatedType;
    }

    @Override
    public void accept(InfoTreeVisitor visitor) {
        visitor.visitEnumInfo(this);
    }

    public ResolvedJavaType getAnnotatedElement() {
        return this.annotatedType;
    }

    public CEnumRuntimeData getRuntimeData() {
        assert (this.runtimeData != null);
        return this.runtimeData;
    }

    public void setRuntimeData(CEnumRuntimeData runtimeData) {
        assert (this.runtimeData == null);
        this.runtimeData = runtimeData;
    }

    public Iterable<AnalysisMethod> getCEnumValueMethods() {
        return this.valueMethods;
    }

    public Iterable<AnalysisMethod> getCEnumLookupMethods() {
        return this.lookupMethods;
    }

    public void addCEnumValueMethod(AnalysisMethod method) {
        this.valueMethods.add(method);
    }

    public void addCEnumLookupMethod(AnalysisMethod method) {
        this.lookupMethods.add(method);
    }

    public boolean hasCEnumLookupMethods() {
        return !this.lookupMethods.isEmpty();
    }
}

