/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.svm.hosted.code.UninterruptibleAnnotationChecker;
import com.oracle.svm.hosted.meta.HostedMethod;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.GraphEncoder;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.vm.ci.code.Architecture;
import org.graalvm.collections.EconomicSet;

public final class CompilationGraph {
    private final EncodedGraph encodedGraph;
    private final int nodeCount;
    private final EconomicSet<InvokeInfo> invokeInfos;
    private final EconomicSet<AllocationInfo> allocationInfos;

    private CompilationGraph(EncodedGraph encodedGraph, int nodeCount, EconomicSet<InvokeInfo> invokeInfos, EconomicSet<AllocationInfo> allocationInfos) {
        this.encodedGraph = encodedGraph;
        this.nodeCount = nodeCount;
        this.invokeInfos = invokeInfos;
        this.allocationInfos = allocationInfos;
    }

    static CompilationGraph encode(StructuredGraph graph) {
        EconomicSet invokeInfos = EconomicSet.create();
        EconomicSet allocationInfos = EconomicSet.create();
        for (Node n : graph.getNodes()) {
            if (n instanceof MethodCallTargetNode) {
                MethodCallTargetNode node = (MethodCallTargetNode)n;
                invokeInfos.add((Object)new InvokeInfo(node.invokeKind(), (HostedMethod)node.targetMethod(), (HostedMethod)node.invoke().stateAfter().getMethod(), node.getNodeSourcePosition()));
            }
            if (!UninterruptibleAnnotationChecker.isAllocationNode(n)) continue;
            allocationInfos.add((Object)new AllocationInfo(n.getNodeSourcePosition()));
        }
        return new CompilationGraph(GraphEncoder.encodeSingleGraph((StructuredGraph)graph, (Architecture)AnalysisParsedGraph.HOST_ARCHITECTURE), graph.getNodeCount(), (EconomicSet<InvokeInfo>)(invokeInfos.isEmpty() ? EconomicSet.emptySet() : invokeInfos), (EconomicSet<AllocationInfo>)(allocationInfos.isEmpty() ? EconomicSet.emptySet() : allocationInfos));
    }

    public EncodedGraph getEncodedGraph() {
        return this.encodedGraph;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public EconomicSet<InvokeInfo> getInvokeInfos() {
        return this.invokeInfos;
    }

    public EconomicSet<AllocationInfo> getAllocationInfos() {
        return this.allocationInfos;
    }

    public static class InvokeInfo {
        private final CallTargetNode.InvokeKind invokeKind;
        private final HostedMethod targetMethod;
        private final HostedMethod directCaller;
        private final NodeSourcePosition nodeSourcePosition;

        InvokeInfo(CallTargetNode.InvokeKind invokeKind, HostedMethod targetMethod, HostedMethod directCaller, NodeSourcePosition nodeSourcePosition) {
            this.invokeKind = invokeKind;
            this.targetMethod = targetMethod;
            this.directCaller = directCaller;
            this.nodeSourcePosition = nodeSourcePosition;
        }

        public CallTargetNode.InvokeKind getInvokeKind() {
            return this.invokeKind;
        }

        public HostedMethod getTargetMethod() {
            return this.targetMethod;
        }

        public HostedMethod getDirectCaller() {
            return this.directCaller;
        }

        public NodeSourcePosition getNodeSourcePosition() {
            return this.nodeSourcePosition;
        }
    }

    public static class AllocationInfo {
        private final NodeSourcePosition nodeSourcePosition;

        AllocationInfo(NodeSourcePosition nodeSourcePosition) {
            this.nodeSourcePosition = nodeSourcePosition;
        }

        public NodeSourcePosition getNodeSourcePosition() {
            return this.nodeSourcePosition;
        }
    }
}

