/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.hub.Hybrid;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedType;
import java.lang.reflect.Modifier;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;

public class HybridLayoutSupport {
    @Fold
    public static HybridLayoutSupport singleton() {
        return (HybridLayoutSupport)ImageSingletons.lookup(HybridLayoutSupport.class);
    }

    public boolean isHybrid(ResolvedJavaType clazz) {
        return clazz.isAnnotationPresent(Hybrid.class);
    }

    public boolean isHybridField(HostedField field) {
        return false;
    }

    public boolean canHybridFieldsBeDuplicated(HostedType clazz) {
        assert (this.isHybrid(clazz)) : "Can only be called on hybrid types";
        return false;
    }

    public boolean canInstantiateAsInstance(HostedType clazz) {
        assert (this.isHybrid(clazz)) : "Can only be called on hybrid types";
        return false;
    }

    protected HybridInfo inspectHybrid(HostedInstanceClass hybridClass, MetaAccessProvider metaAccess) {
        assert (Modifier.isFinal(hybridClass.getModifiers())) : "Hybrid class must be final " + String.valueOf(hybridClass);
        Class<?> componentType = hybridClass.getAnnotation(Hybrid.class).componentType();
        assert (componentType != Void.TYPE) : "@Hybrid.componentType cannot be void";
        return new HybridInfo((HostedType)metaAccess.lookupJavaType(componentType), null);
    }

    public static class HybridInfo {
        public final HostedType arrayComponentType;
        public final HostedField arrayField;

        public HybridInfo(HostedType arrayComponentType, HostedField arrayField) {
            this.arrayComponentType = arrayComponentType;
            this.arrayField = arrayField;
        }
    }
}

