/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.driver;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IncludeOptionsSupport {
    public static String possibleExtendedOptions() {
        return Stream.of("module", "package", "path").map(option -> option + "=<" + option + ">").collect(Collectors.joining(", "));
    }

    public static void parseIncludeSelector(String optionArg, LocatableMultiOptionValue.ValueWithOrigin<String> valueWithOrigin, NativeImageClassLoaderSupport.IncludeSelectors includeSelectors, ExtendedOption option, String possibleOptions) {
        boolean validOption = option.value() != null && !option.value().isEmpty();
        switch (option.key()) {
            case "module": {
                UserError.guarantee(validOption, "Option %s specified with '%s' from %s requires a module name argument, e.g., %s=module-name.", option.key(), optionArg, valueWithOrigin.origin(), option.key());
                includeSelectors.addModule(option.value, new ExtendedOptionWithOrigin(option, valueWithOrigin));
                break;
            }
            case "package": {
                UserError.guarantee(validOption, "Option %s specified with '%s' from %s requires a package name argument, e.g., %s=package-name.", option.key(), optionArg, valueWithOrigin.origin(), option.key());
                includeSelectors.addPackage(Objects.requireNonNull(PackageOptionValue.from(option)));
                break;
            }
            case "path": {
                UserError.guarantee(validOption, "Option %s specified with '%s' from %s requires a class-path entry, e.g., %s=path/to/cp-entry.", option.key(), optionArg, valueWithOrigin.origin(), option.key());
                includeSelectors.addClassPathEntry(option.value(), new ExtendedOptionWithOrigin(option, valueWithOrigin));
                break;
            }
            default: {
                throw UserError.abort("Unknown option '%s' specified with %s from %s. The possible options are: " + possibleOptions, option.key(), optionArg, valueWithOrigin.origin());
            }
        }
    }

    public record ExtendedOption(String key, String value) {
        public static final String PACKAGE_OPTION = "package";
        public static final String MODULE_OPTION = "module";
        public static final String PATH_OPTION = "path";

        public static ExtendedOption parse(String option) {
            String[] optionParts = SubstrateUtil.split(option, "=", 2);
            if (optionParts.length == 2) {
                return new ExtendedOption(optionParts[0], optionParts[1]);
            }
            return new ExtendedOption(option, null);
        }
    }

    public record ExtendedOptionWithOrigin(ExtendedOption option, LocatableMultiOptionValue.ValueWithOrigin<?> valueWithOrigin) {
    }

    public record PackageOptionValue(String name, boolean isWildcard) {
        static final String PACKAGE_WILDCARD_SUFFIX = ".*";

        public static PackageOptionValue from(ExtendedOption extendedOption) {
            if (!extendedOption.key().equals("package")) {
                return null;
            }
            String extendedOptionValue = extendedOption.value();
            if (extendedOptionValue.endsWith(PACKAGE_WILDCARD_SUFFIX)) {
                return new PackageOptionValue(extendedOptionValue.substring(0, extendedOptionValue.length() - PACKAGE_WILDCARD_SUFFIX.length()), true);
            }
            return new PackageOptionValue(extendedOptionValue, false);
        }

        @Override
        public String toString() {
            return this.name + (this.isWildcard ? PACKAGE_WILDCARD_SUFFIX : "");
        }
    }
}

