/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.FeatureSingleton;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class LayeredImageHooks
implements InternalFeature,
FeatureSingleton {
    private final Set<Consumer<WrittenDynamicHubInfo>> hubWrittenCallbacks = ConcurrentHashMap.newKeySet();

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ImageLayerBuildingSupport.buildingImageLayer();
    }

    private static LayeredImageHooks singleton() {
        return (LayeredImageHooks)ImageSingletons.lookup(LayeredImageHooks.class);
    }

    public static void registerDynamicHubWrittenCallback(Consumer<WrittenDynamicHubInfo> consumer) {
        LayeredImageHooks.singleton().hubWrittenCallbacks.add(consumer);
    }

    public static void processWrittenDynamicHub(WrittenDynamicHubInfo info) {
        LayeredImageHooks.singleton().hubWrittenCallbacks.forEach(callback -> callback.accept(info));
    }

    public record WrittenDynamicHubInfo(DynamicHub hub, AnalysisUniverse aUniverse, HostedUniverse hUniverse, Object vTable) {
    }
}

