/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.imagelayer.PriorLayerMarker;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.reflect.serialize.SerializationSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.BootLoaderSupport;
import com.oracle.svm.hosted.ClassLoaderFeature;
import com.oracle.svm.hosted.imagelayer.CrossLayerConstantRegistry;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.internal.loader.ClassLoaders;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredImageSingleton
public class HostedClassLoaderPackageManagement
implements LayeredImageSingleton {
    private static final String APP_KEY = "AppPackageNames";
    private static final String PLATFORM_KEY = "PlatformPackageNames";
    private static final String BOOT_KEY = "BootPackageNames";
    private static final String GENERATED_SERIALIZATION_KEY = "GeneratedSerializationNames";
    private static final String GENERATED_SERIALIZATION_PACKAGE = "jdk.internal.reflect";
    private static final Method packageGetPackageInfo = ReflectionUtil.lookupMethod(Package.class, (String)"getPackageInfo", (Class[])new Class[0]);
    private static final ClassLoader platformClassLoader;
    private static final ClassLoader bootClassLoader;
    private static final Method moduleLookup;
    private final boolean inExtensionLayer;
    private final boolean inSharedLayer;
    private final Set<String> priorAppPackageNames;
    private final Set<String> priorPlatformPackageNames;
    private final Set<String> priorBootPackageNames;
    private final ConcurrentMap<ClassLoader, ConcurrentHashMap<String, Package>> registeredPackages = new ConcurrentHashMap<ClassLoader, ConcurrentHashMap<String, Package>>();
    private ClassLoader appClassLoader;
    private CrossLayerConstantRegistry registry;

    public HostedClassLoaderPackageManagement() {
        this.inExtensionLayer = false;
        this.inSharedLayer = ImageLayerBuildingSupport.buildingSharedLayer();
        this.priorAppPackageNames = null;
        this.priorPlatformPackageNames = null;
        this.priorBootPackageNames = null;
    }

    private HostedClassLoaderPackageManagement(Set<String> appPackages, Set<String> platformPackages, Set<String> bootPackages) {
        VMError.guarantee(ImageLayerBuildingSupport.buildingExtensionLayer(), "Unexpected invocation");
        this.inExtensionLayer = true;
        this.inSharedLayer = ImageLayerBuildingSupport.buildingSharedLayer();
        this.priorAppPackageNames = appPackages;
        this.priorPlatformPackageNames = platformPackages;
        this.priorBootPackageNames = bootPackages;
    }

    public static HostedClassLoaderPackageManagement singleton() {
        return (HostedClassLoaderPackageManagement)ImageSingletons.lookup(HostedClassLoaderPackageManagement.class);
    }

    private boolean isPackageRegistered(ClassLoader classLoader, String packageName, Package packageValue) {
        ConcurrentHashMap loaderPackages;
        if (this.inExtensionLayer) {
            if (classLoader == bootClassLoader) {
                boolean result = this.priorBootPackageNames.contains(packageName);
                VMError.guarantee(result, "Newly seen boot package %s", packageValue);
                return true;
            }
            if (classLoader == platformClassLoader) {
                boolean result = this.priorPlatformPackageNames.contains(packageName);
                VMError.guarantee(result, "Newly seen platform package %s", packageValue);
                return true;
            }
            if (classLoader == this.appClassLoader) {
                if (this.priorAppPackageNames.contains(packageName)) {
                    return true;
                }
            } else {
                if (HostedClassLoaderPackageManagement.isGeneratedSerializationClassLoader(classLoader)) {
                    VMError.guarantee(packageName.equals(GENERATED_SERIALIZATION_PACKAGE), "Unexpected package %s in generated serialization class loader", packageValue);
                    return true;
                }
                throw VMError.shouldNotReachHere("Currently unhandled class loader seen in extension layer: %s", classLoader);
            }
        }
        return (loaderPackages = (ConcurrentHashMap)this.registeredPackages.get(classLoader)) != null && loaderPackages.containsKey(packageName);
    }

    public static boolean isGeneratedSerializationClassLoader(ClassLoader classLoader) {
        return SerializationSupport.currentLayer().isGeneratedSerializationClassLoader(classLoader);
    }

    public static String getClassLoaderSerializationLookupKey(ClassLoader classLoader) {
        return GENERATED_SERIALIZATION_KEY + SerializationSupport.currentLayer().getClassLoaderSerializationLookupKey(classLoader);
    }

    public void registerPackage(ClassLoader runtimeClassLoader, String packageName, Package packageValue, Consumer<Object> objectScanner) {
        assert (runtimeClassLoader != null);
        assert (packageName != null);
        assert (packageValue != null);
        VMError.guarantee(!BuildPhaseProvider.isAnalysisFinished(), "Packages should be collected and registered during analysis.");
        if (this.isPackageRegistered(runtimeClassLoader, packageName, packageValue)) {
            return;
        }
        try {
            packageGetPackageInfo.invoke((Object)packageValue, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
        ConcurrentHashMap loaderPackages = this.registeredPackages.computeIfAbsent(runtimeClassLoader, k -> new ConcurrentHashMap());
        Package previous = loaderPackages.putIfAbsent(packageName, packageValue);
        if (previous == null) {
            objectScanner.accept(loaderPackages);
            if (this.inSharedLayer && runtimeClassLoader == this.appClassLoader) {
                VMError.guarantee(packageValue.getName().equals(packageName), "Package name is different from package value's name: %s %s", packageName, packageValue);
                this.registry.registerHeapConstant(HostedClassLoaderPackageManagement.generateKeyName(packageValue.getName()), packageValue);
            }
        }
    }

    public ImageHeapConstant replaceWithPriorLayerPackage(Object obj) {
        if (obj instanceof Package) {
            Package hostedPackage = (Package)obj;
            Module module = (Module)ReflectionUtil.invokeMethod((Method)moduleLookup, (Object)hostedPackage, (Object[])new Object[0]);
            ClassLoader classLoader = ClassLoaderFeature.getRuntimeClassLoader(module.getClassLoader());
            VMError.guarantee(classLoader == this.appClassLoader, "Currently unhandled class loader seen in extension layer: %s", classLoader);
            String keyName = HostedClassLoaderPackageManagement.generateKeyName(hostedPackage.getName());
            if (this.registry.constantExists(keyName)) {
                return (ImageHeapConstant)this.registry.getConstant(keyName);
            }
        }
        return null;
    }

    private static String generateKeyName(String packageName) {
        return String.format("AppClassLoaderPackage#%s", packageName);
    }

    public ConcurrentHashMap<String, Package> getRegisteredPackages(ClassLoader classLoader) {
        VMError.guarantee(BuildPhaseProvider.isAnalysisFinished(), "Packages are stable only after analysis.");
        VMError.guarantee(ImageLayerBuildingSupport.firstImageBuild(), "All classloaders should be transformed in the first layer %s", classLoader);
        return (ConcurrentHashMap)this.registeredPackages.get(classLoader);
    }

    public ConcurrentHashMap<String, Object> getAppClassLoaderPackages() {
        VMError.guarantee(BuildPhaseProvider.isAnalysisFinished(), "Packages are stable only after analysis.");
        VMError.guarantee(ImageLayerBuildingSupport.lastImageBuild(), "AppClassLoader's Packages are only fully available in the application layer");
        ConcurrentHashMap<String, Object> finalAppMap = this.getPriorAppClassLoaderPackages();
        ConcurrentHashMap currentPackages = (ConcurrentHashMap)this.registeredPackages.get(this.appClassLoader);
        if (currentPackages != null) {
            for (Map.Entry entry : currentPackages.entrySet()) {
                Object previous = finalAppMap.put((String)entry.getKey(), entry.getValue());
                assert (previous == null) : Assertions.errorMessage((Object[])new Object[]{entry.getKey(), previous});
            }
        }
        return finalAppMap;
    }

    public ConcurrentHashMap<String, Object> getPriorAppClassLoaderPackages() {
        ConcurrentHashMap<String, Object> finalAppMap = new ConcurrentHashMap<String, Object>();
        for (String name : this.priorAppPackageNames) {
            Object previous = finalAppMap.put(name, new PriorLayerPackageReference(HostedClassLoaderPackageManagement.generateKeyName(name)));
            assert (previous == null) : Assertions.errorMessage((Object[])new Object[]{name, previous});
        }
        return finalAppMap;
    }

    public void initialize(ClassLoader newAppClassLoader, CrossLayerConstantRegistry newRegistry) {
        assert (this.appClassLoader == null && newAppClassLoader != null) : Assertions.errorMessage((Object[])new Object[]{this.appClassLoader, newAppClassLoader});
        assert (this.registry == null && newRegistry != null) : Assertions.errorMessage((Object[])new Object[]{this.registry, newRegistry});
        this.appClassLoader = newAppClassLoader;
        this.registry = newRegistry;
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    private List<String> collectPackageNames(ClassLoader classLoader, Set<String> priorPackageNames) {
        ConcurrentHashMap map = (ConcurrentHashMap)this.registeredPackages.get(classLoader);
        if (priorPackageNames != null && map != null) {
            return Stream.concat(map.keySet().stream(), priorPackageNames.stream()).toList();
        }
        if (priorPackageNames == null && map != null) {
            return map.keySet().stream().toList();
        }
        if (priorPackageNames != null && map == null) {
            return priorPackageNames.stream().toList();
        }
        throw VMError.shouldNotReachHere("Bad state: %s %s", priorPackageNames, map);
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        writer.writeStringList(APP_KEY, this.collectPackageNames(this.appClassLoader, this.priorAppPackageNames));
        writer.writeStringList(PLATFORM_KEY, this.collectPackageNames(platformClassLoader, this.priorPlatformPackageNames));
        writer.writeStringList(BOOT_KEY, this.collectPackageNames(bootClassLoader, this.priorBootPackageNames));
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        Set<String> appSet = loader.readStringList(APP_KEY).stream().collect(Collectors.toUnmodifiableSet());
        Set<String> platformSet = loader.readStringList(PLATFORM_KEY).stream().collect(Collectors.toUnmodifiableSet());
        Set<String> bootSet = loader.readStringList(BOOT_KEY).stream().collect(Collectors.toUnmodifiableSet());
        return new HostedClassLoaderPackageManagement(appSet, platformSet, bootSet);
    }

    static {
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            platformClassLoader = ClassLoaders.platformClassLoader();
            bootClassLoader = BootLoaderSupport.getBootLoader();
            moduleLookup = ImageLayerBuildingSupport.buildingExtensionLayer() ? ReflectionUtil.lookupMethod((Class)ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.NamedPackage"), (String)"module", (Class[])new Class[0]) : null;
        } else {
            platformClassLoader = null;
            bootClassLoader = null;
            moduleLookup = null;
        }
    }

    private record PriorLayerPackageReference(String key) implements PriorLayerMarker
    {
        @Override
        public String getKey() {
            return this.key;
        }
    }
}

