/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jfr;

import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.jfr.JfrJavaEvents;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.ConcurrentHashMap;
import jdk.internal.event.Event;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.MetadataRepository;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class JfrEventSubstitution
extends SubstitutionProcessor {
    private final ImageHeapScanner heapScanner;
    private final ResolvedJavaType baseEventType;
    private final ConcurrentHashMap<ResolvedJavaType, Boolean> typeSubstitution;
    private final ConcurrentHashMap<ResolvedJavaMethod, ResolvedJavaMethod> methodSubstitutions;
    private final ConcurrentHashMap<ResolvedJavaField, ResolvedJavaField> fieldSubstitutions;

    JfrEventSubstitution(MetaAccessProvider metaAccess, ImageHeapScanner heapScanner) {
        this.heapScanner = heapScanner;
        this.baseEventType = metaAccess.lookupJavaType(Event.class);
        this.typeSubstitution = new ConcurrentHashMap();
        this.methodSubstitutions = new ConcurrentHashMap();
        this.fieldSubstitutions = new ConcurrentHashMap();
    }

    public ResolvedJavaField lookup(ResolvedJavaField field) {
        ResolvedJavaType type = field.getDeclaringClass();
        if (this.needsClassRedefinition(type)) {
            this.typeSubstitution.computeIfAbsent(type, this::initEventClass);
            return this.fieldSubstitutions.computeIfAbsent(field, JfrEventSubstitution::initEventField);
        }
        return field;
    }

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        ResolvedJavaType type = method.getDeclaringClass();
        if (this.needsClassRedefinition(type)) {
            this.typeSubstitution.computeIfAbsent(type, this::initEventClass);
            return this.methodSubstitutions.computeIfAbsent(method, JfrEventSubstitution::initEventMethod);
        }
        return method;
    }

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        if (this.needsClassRedefinition(type)) {
            this.typeSubstitution.computeIfAbsent(type, this::initEventClass);
        }
        return type;
    }

    private static ResolvedJavaField initEventField(ResolvedJavaField oldField) throws RuntimeException {
        ResolvedJavaType type = oldField.getDeclaringClass();
        if (oldField.isStatic()) {
            for (ResolvedJavaField field : type.getStaticFields()) {
                if (!field.getName().equals(oldField.getName())) continue;
                return field;
            }
        } else {
            for (ResolvedJavaField field : type.getInstanceFields(false)) {
                if (!field.getName().equals(oldField.getName())) continue;
                return field;
            }
        }
        throw VMError.shouldNotReachHere("Could not re-resolve field: " + String.valueOf(oldField));
    }

    private static ResolvedJavaMethod initEventMethod(ResolvedJavaMethod oldMethod) throws RuntimeException {
        ResolvedJavaMethod newMethod;
        ResolvedJavaType type = oldMethod.getDeclaringClass();
        String name = oldMethod.getName();
        Signature signature = oldMethod.getSignature();
        if (name.equals("<clinit>")) {
            return type.getClassInitializer();
        }
        if (name.equals("<init>")) {
            for (ResolvedJavaMethod m : type.getDeclaredConstructors(false)) {
                if (!m.getName().equals(name) || !m.getSignature().equals((Object)signature)) continue;
                return m;
            }
        }
        if ((newMethod = type.findMethod(name, signature)) != null) {
            return newMethod;
        }
        throw VMError.shouldNotReachHere("Could not re-resolve method: " + String.valueOf(oldMethod));
    }

    private Boolean initEventClass(ResolvedJavaType eventType) throws RuntimeException {
        VMError.guarantee(!BuildPhaseProvider.isAnalysisFinished());
        try {
            Class<Event> newEventClass = OriginalClassProvider.getJavaClass((JavaType)eventType).asSubclass(Event.class);
            eventType.initialize();
            MetadataRepository.getInstance().register(newEventClass);
            JfrJavaEvents.registerEventClass(newEventClass);
            JVM.retransformClasses(new Class[]{newEventClass});
            this.heapScanner.rescanObject(JVM.getConfiguration(newEventClass));
            return Boolean.TRUE;
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private boolean needsClassRedefinition(ResolvedJavaType type) {
        return !type.isAbstract() && this.baseEventType.isAssignableFrom(type) && !this.baseEventType.equals((Object)type);
    }
}

