/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.methodhandles;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerWriter;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.replacements.MethodHandleWithExceptionPlugin;
import jdk.graal.compiler.replacements.nodes.MacroInvokable;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class SVMMethodHandleWithExceptionPlugin
extends MethodHandleWithExceptionPlugin {
    public SVMMethodHandleWithExceptionPlugin(MethodHandleAccessProvider methodHandleAccess, boolean safeForDeoptimization) {
        super(methodHandleAccess, safeForDeoptimization);
    }

    protected void onCreateHook(MacroInvokable methodHandleNode, GraphBuilderContext b) {
        if (HostedImageLayerBuildingSupport.buildingSharedLayer()) {
            SVMImageLayerWriter writer = HostedImageLayerBuildingSupport.singleton().getWriter();
            ResolvedJavaMethod resolvedJavaMethod = methodHandleNode.getTargetMethod();
            if (resolvedJavaMethod instanceof AnalysisMethod) {
                AnalysisMethod methodHandleMethod = (AnalysisMethod)resolvedJavaMethod;
                resolvedJavaMethod = b.getMethod();
                if (resolvedJavaMethod instanceof AnalysisMethod) {
                    AnalysisMethod caller = (AnalysisMethod)resolvedJavaMethod;
                    writer.addPolymorphicSignatureCaller(methodHandleMethod, caller);
                }
            }
        }
    }
}

