/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import java.util.function.Supplier;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

public class SubstrateClassInitializationPlugin
implements ClassInitializationPlugin {
    private final SVMHost host;

    public SubstrateClassInitializationPlugin(SVMHost host) {
        this.host = host;
    }

    public boolean supportsLazyInitialization(ConstantPool cp) {
        return true;
    }

    public void loadReferencedType(GraphBuilderContext builder, ConstantPool constantPool, int cpi, int bytecode) {
        constantPool.loadReferencedType(cpi, bytecode);
    }

    public boolean apply(GraphBuilderContext builder, ResolvedJavaType type, Supplier<FrameState> frameState) {
        boolean requiredForTypeReached = ClassInitializationSupport.singleton().requiresInitializationNodeForTypeReached(type);
        if (requiredForTypeReached || EnsureClassInitializedNode.needsRuntimeInitialization(builder.getMethod().getDeclaringClass(), type)) {
            assert (!type.isArray()) : "Array types must not have initialization nodes: " + type.getName();
            SnippetReflectionProvider snippetReflection = builder.getSnippetReflection();
            SubstrateClassInitializationPlugin.emitEnsureClassInitialized(builder, snippetReflection.forObject((Object)this.host.dynamicHub(type)), frameState.get());
            return true;
        }
        return false;
    }

    private static void emitEnsureClassInitialized(GraphBuilderContext builder, JavaConstant hubConstant, FrameState frameState) {
        ConstantNode hub = ConstantNode.forConstant((JavaConstant)hubConstant, (MetaAccessProvider)builder.getMetaAccess(), (StructuredGraph)builder.getGraph());
        EnsureClassInitializedNode node = new EnsureClassInitializedNode((ValueNode)hub, frameState);
        builder.canonicalizeAndAdd((Node)node);
    }
}

