/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect.serialize;

import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.util.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

final class SerializationDenyRegistry
implements RuntimeSerializationSupport<ConfigurationCondition> {
    private final Map<Class<?>, Boolean> deniedClasses = new HashMap();
    private final ConfigurationTypeResolver typeResolver;

    SerializationDenyRegistry(ConfigurationTypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void registerIncludingAssociatedClasses(ConfigurationCondition condition, Class<?> clazz) {
        this.register(condition, clazz);
    }

    public void register(ConfigurationCondition condition, Class<?> clazz) {
        if (clazz != null) {
            this.deniedClasses.put(clazz, true);
        }
    }

    public void register(ConfigurationCondition condition, String className) {
        this.register(condition, this.typeResolver.resolveType(className));
    }

    public void registerLambdaCapturingClass(ConfigurationCondition condition, String lambdaCapturingClassName) {
        Class<?> lambdaCapturingClass = this.typeResolver.resolveType(lambdaCapturingClassName);
        if (lambdaCapturingClass != null) {
            this.deniedClasses.put(lambdaCapturingClass, true);
        }
    }

    public void registerProxyClass(ConfigurationCondition condition, List<String> implementedInterfaces) {
    }

    public boolean isAllowed(Class<?> clazz) {
        boolean denied = this.deniedClasses.containsKey(clazz);
        if (denied && this.deniedClasses.get(clazz).booleanValue()) {
            this.deniedClasses.put(clazz, false);
            LogUtils.warning((String)"Serialization deny list contains %s. Image will not support serialization/deserialization of this class.", (Object[])new Object[]{clazz.getName()});
        }
        return !denied;
    }
}

