/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class JDKArgsUtils {
    public static List<String> parseArgsFromEnvVar(String envVarValue, String envVarName, Function<String, Error> errorFunction) {
        ArrayList<String> result = new ArrayList<String>();
        int envVarValueLength = envVarValue.length();
        int i = 0;
        while (i < envVarValueLength) {
            boolean isArgFileOption;
            char currentChar;
            while (i < envVarValueLength && JDKArgsUtils.isspace(envVarValue.charAt(i))) {
                ++i;
            }
            if (i >= envVarValueLength) break;
            StringBuilder argChars = new StringBuilder();
            while (i < envVarValueLength && !JDKArgsUtils.isspace(currentChar = envVarValue.charAt(i))) {
                if (currentChar == '\"' || currentChar == '\'') {
                    char quote = currentChar;
                    ++i;
                    while (i < envVarValueLength && envVarValue.charAt(i) != quote) {
                        argChars.append(envVarValue.charAt(i++));
                    }
                    if (i >= envVarValueLength) {
                        throw errorFunction.apply("Unmatched quote in environment variable " + envVarName);
                    }
                    ++i;
                    continue;
                }
                argChars.append(envVarValue.charAt(i++));
            }
            String argument = argChars.toString();
            boolean bl = isArgFileOption = argument.startsWith("@") && !argument.startsWith("@@");
            if (isArgFileOption || JDKArgsUtils.isTerminalOpt(argument)) {
                throw errorFunction.apply("Option '" + argument + "' is not allowed in environment variable " + envVarName);
            }
            result.add(argument);
            assert (i >= envVarValueLength || JDKArgsUtils.isspace(envVarValue.charAt(i)));
        }
        return result;
    }

    public static boolean isspace(char value) {
        return value == ' ' || value == '\f' || value == '\n' || value == '\r' || value == '\t';
    }

    private static boolean isTerminalOpt(String arg) {
        return switch (arg) {
            case "-jar", "-m", "--module", "--dry-run", "--help", "--help-extra", "--version" -> true;
            case "-h", "-?", "-help", "-X", "-version", "-fullversion", "--full-version" -> true;
            case "--expert-options", "--expert-options-all", "--expert-options-detail" -> true;
            default -> arg.startsWith("--module=");
        };
    }
}

