/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.metadata.ByteUtils;
import com.oracle.svm.interpreter.metadata.Bytecodes;
import com.oracle.svm.interpreter.metadata.LookupSwitch;
import com.oracle.svm.interpreter.metadata.TableSwitch;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class BytecodeStream {
    private BytecodeStream() {
        throw VMError.shouldNotReachHere("private constructor");
    }

    public static int nextBCI(byte[] code, int curBCI) {
        return curBCI + BytecodeStream.lengthOf(code, curBCI);
    }

    public static int endBCI(byte[] code) {
        return code.length;
    }

    public static int currentBC(byte[] code, int curBCI) {
        int opcode = BytecodeStream.opcode(code, curBCI);
        if (opcode == 196) {
            return ByteUtils.beU1(code, curBCI + 1);
        }
        return opcode;
    }

    public static int currentVolatileBC(byte[] code, int curBCI) {
        int opcode = BytecodeStream.volatileOpcode(code, curBCI);
        if (opcode == 196) {
            return ByteUtils.volatileBeU1(code, curBCI + 1);
        }
        return opcode;
    }

    public static int readLocalIndex(byte[] code, int curBCI) {
        if (BytecodeStream.opcode(code, curBCI) == 196) {
            return ByteUtils.beU2(code, curBCI + 2);
        }
        return ByteUtils.beU1(code, curBCI + 1);
    }

    public static int readLocalIndex1(byte[] code, int curBCI) {
        return ByteUtils.beU1(code, curBCI + 1);
    }

    public static int readLocalIndex2(byte[] code, int curBCI) {
        return ByteUtils.beU2(code, curBCI + 2);
    }

    public static int readIncrement(byte[] code, int curBCI) {
        if (BytecodeStream.opcode(code, curBCI) == 196) {
            return ByteUtils.beS2(code, curBCI + 4);
        }
        return ByteUtils.beS1(code, curBCI + 2);
    }

    public static int readIncrement1(byte[] code, int curBCI) {
        return ByteUtils.beS1(code, curBCI + 2);
    }

    public static int readIncrement2(byte[] code, int curBCI) {
        return ByteUtils.beS2(code, curBCI + 4);
    }

    public static int readBranchDest(byte[] code, int curBCI) {
        int opcode = BytecodeStream.opcode(code, curBCI);
        if (opcode == 200 || opcode == 201) {
            return curBCI + ByteUtils.beS4(code, curBCI + 1);
        }
        return curBCI + ByteUtils.beS2(code, curBCI + 1);
    }

    public static int readBranchDest4(byte[] code, int curBCI) {
        return curBCI + ByteUtils.beS4(code, curBCI + 1);
    }

    public static int readBranchDest2(byte[] code, int curBCI) {
        return curBCI + ByteUtils.beS2(code, curBCI + 1);
    }

    public static int readInt(byte[] code, int bci) {
        return ByteUtils.beS4(code, bci);
    }

    public static int readUByte(byte[] code, int bci) {
        return ByteUtils.beU1(code, bci);
    }

    public static char readCPI1(byte[] code, int curBCI) {
        return (char)ByteUtils.beU1(code, curBCI + 1);
    }

    public static char readCPI2(byte[] code, int curBCI) {
        return (char)ByteUtils.beU2(code, curBCI + 1);
    }

    public static char readCPI(byte[] code, int curBCI) {
        if (BytecodeStream.opcode(code, curBCI) == 18) {
            return (char)ByteUtils.beU1(code, curBCI + 1);
        }
        return (char)ByteUtils.beU2(code, curBCI + 1);
    }

    public static int readCPI4(byte[] code, int curBCI) {
        assert (BytecodeStream.opcode(code, curBCI) == 186);
        return ByteUtils.beS4(code, curBCI + 1);
    }

    public static byte readByte(byte[] code, int curBCI) {
        return code[curBCI + 1];
    }

    public static short readShort(byte[] code, int curBCI) {
        return (short)ByteUtils.beS2(code, curBCI + 1);
    }

    public static int opcode(byte[] code, int curBCI) {
        return ByteUtils.beU1(code, curBCI);
    }

    public static int opaqueOpcode(byte[] code, int curBCI) {
        return ByteUtils.opaqueBeU1(code, curBCI);
    }

    public static int volatileOpcode(byte[] code, int curBCI) {
        return ByteUtils.volatileBeU1(code, curBCI);
    }

    private static int lengthOf(byte[] code, int curBCI) {
        int opcode = BytecodeStream.opcode(code, curBCI);
        int length = Bytecodes.lengthOf(opcode);
        if (length == 0) {
            switch (opcode) {
                case 170: {
                    return TableSwitch.size(code, curBCI);
                }
                case 171: {
                    return LookupSwitch.size(code, curBCI);
                }
                case 196: {
                    int opc = ByteUtils.beU1(code, curBCI + 1);
                    if (opc == 132) {
                        return 6;
                    }
                    return 4;
                }
            }
            throw VMError.shouldNotReachHere(BytecodeStream.unknownVariableLengthBytecodeMessage(opcode));
        }
        return length;
    }

    private static String unknownVariableLengthBytecodeMessage(int opcode) {
        return "unknown variable-length bytecode: " + opcode;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void patchAppendixCPI(byte[] code, int curBCI, int appendixCPI) {
        int opcode = BytecodeStream.opcode(code, curBCI);
        switch (opcode) {
            case 186: {
                code[curBCI + 3] = (byte)(appendixCPI >> 8 & 0xFF);
                code[curBCI + 4] = (byte)(appendixCPI & 0xFF);
                break;
            }
            default: {
                throw VMError.shouldNotReachHereAtRuntime();
            }
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void patchCPI(byte[] code, int curBCI, int newCPI) {
        int opcode = BytecodeStream.opcode(code, curBCI);
        switch (opcode) {
            case 196: {
                throw VMError.intentionallyUnimplemented();
            }
            case 18: {
                VMError.guarantee(0 <= newCPI && newCPI <= 255);
                code[curBCI + 1] = (byte)newCPI;
                break;
            }
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 197: {
                VMError.guarantee(0 <= newCPI && newCPI <= 65535);
                code[curBCI + 1] = (byte)(newCPI >> 8 & 0xFF);
                code[curBCI + 2] = (byte)(newCPI & 0xFF);
                break;
            }
            default: {
                throw VMError.intentionallyUnimplemented();
            }
        }
    }

    public static void patchOpcodeOpaque(byte[] code, int curBCI, int newOpcode) {
        assert (0 <= newOpcode && newOpcode < 256);
        ByteUtils.opaqueWrite(code, curBCI, (byte)newOpcode);
    }
}

