/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import java.util.Objects;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class ReferenceConstant<T>
implements JavaConstant {
    private final T ref;
    private final long imageHeapOffset;
    private static final ReferenceConstant<?> NULL = new ReferenceConstant<Object>(null);

    private ReferenceConstant(T ref) {
        this.imageHeapOffset = 0L;
        this.ref = ref;
    }

    private ReferenceConstant(long heapOffset) {
        this.imageHeapOffset = heapOffset;
        this.ref = null;
    }

    public static <T> ReferenceConstant<T> createFromNonNullReference(T ref) {
        return new ReferenceConstant<T>(MetadataUtil.requireNonNull(ref));
    }

    public static <T> ReferenceConstant<T> createFromReference(T ref) {
        if (ref == null) {
            return new ReferenceConstant<Object>(null);
        }
        return ReferenceConstant.createFromNonNullReference(ref);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static ReferenceConstant<?> createFromImageHeapConstant(ImageHeapConstant imageHeapConstant) {
        assert (!imageHeapConstant.isNull()) : imageHeapConstant;
        return new ReferenceConstant<ImageHeapConstant>(Objects.requireNonNull(imageHeapConstant));
    }

    public static <T> ReferenceConstant<T> createFromHeapOffset(long nativeHeapOffset) {
        assert (nativeHeapOffset != 0L);
        return new ReferenceConstant<T>(nativeHeapOffset);
    }

    public T getReferent() {
        if (this.isOpaque()) {
            throw new UnsupportedOperationException("Cannot extract opaque referent");
        }
        return this.ref;
    }

    public String toString() {
        return "ReferenceConstant<" + String.valueOf(this.ref) + ">";
    }

    public boolean isOpaque() {
        return this.imageHeapOffset != 0L;
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public boolean isNull() {
        return this.ref == null && this.imageHeapOffset == 0L;
    }

    public boolean isDefaultForKind() {
        return this.isNull();
    }

    public Object asBoxedPrimitive() {
        throw new IllegalArgumentException();
    }

    public int asInt() {
        throw new IllegalArgumentException();
    }

    public boolean asBoolean() {
        throw new IllegalArgumentException();
    }

    public long asLong() {
        throw new IllegalArgumentException();
    }

    public float asFloat() {
        throw new IllegalArgumentException();
    }

    public double asDouble() {
        throw new IllegalArgumentException();
    }

    public int hashCode() {
        return System.identityHashCode(this.ref) ^ (int)(this.imageHeapOffset ^ this.imageHeapOffset >>> 32);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReferenceConstant)) return false;
        ReferenceConstant that = (ReferenceConstant)other;
        if (this.imageHeapOffset != that.imageHeapOffset) return false;
        if (this.ref != that.ref) return false;
        return true;
    }

    public static <R> ReferenceConstant<R> nullReference() {
        return NULL;
    }
}

