/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.resident;

import com.oracle.svm.jdwp.resident.ThreadStartDeathSupport;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.internal.misc.Unsafe;
import org.graalvm.nativeimage.ImageSingletons;

public final class ObjectIdMap {
    private static final int INITIAL_SIZE_BITS = 10;
    private static final int RESIZE_ATTEMPT = 16;
    private volatile LockFreeHashMap map;
    private static final long mapOffset = Unsafe.getUnsafe().objectFieldOffset(ObjectIdMap.class, "map");

    private static long getObjectArrayByteOffset(long index) {
        long offset = Unsafe.getUnsafe().arrayBaseOffset(Object[].class);
        int scale = Unsafe.getUnsafe().arrayIndexScale(Object[].class);
        try {
            return Math.addExact(offset, Math.multiplyExact(index, scale));
        }
        catch (ArithmeticException ex) {
            throw new IndexOutOfBoundsException(index);
        }
    }

    private static <T> T getElementVolatile(T[] array, long index) {
        long arrayByteOffset = ObjectIdMap.getObjectArrayByteOffset(index);
        return (T)Unsafe.getUnsafe().getReferenceVolatile(array, arrayByteOffset);
    }

    private static boolean compareAndSetElement(Object[] array, long index, Object existingElement, Object newElement) {
        long arrayByteOffset = ObjectIdMap.getObjectArrayByteOffset(index);
        return Unsafe.getUnsafe().compareAndSetReference(array, arrayByteOffset, existingElement, newElement);
    }

    private LockFreeHashMap getMap() {
        LockFreeHashMap theMap = this.map;
        if (theMap == null) {
            theMap = new LockFreeHashMap();
            LockFreeHashMap oldMap = (LockFreeHashMap)Unsafe.getUnsafe().compareAndExchangeReference(this, mapOffset, null, theMap);
            if (oldMap != null) {
                theMap = oldMap;
            }
        }
        return theMap;
    }

    public long getIdExisting(Object obj) {
        if (obj == null) {
            return 0L;
        }
        return this.getMap().getIdExisting(obj);
    }

    public long getIdOrCreateWeak(Object obj) {
        return this.getMap().getIdOrCreateWeak(obj);
    }

    public Object getObject(long id) {
        if (id == 0L) {
            return null;
        }
        return this.getMap().getObject(id);
    }

    public boolean enableCollection(long id) {
        return this.enableCollection(id, 1, false);
    }

    public boolean enableCollection(long id, int refCount, boolean disposeIfNotHold) {
        return this.getMap().enableCollection(id, refCount, disposeIfNotHold);
    }

    public boolean disableCollection(long id) {
        return this.getMap().disableCollection(id);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Intentional.")
    public Boolean isCollected(long id) {
        return this.getMap().isCollected(id);
    }

    public void reset() {
        LockFreeHashMap theMap;
        do {
            if ((theMap = this.map) != null) continue;
            return;
        } while (!Unsafe.getUnsafe().compareAndSetReference(this, mapOffset, theMap, null));
        theMap.reset();
    }

    public <T> T toObject(long objectId, Class<T> targetClass) {
        Object object = this.getObject(objectId);
        return targetClass.cast(object);
    }

    public long toId(Object object) {
        return this.getIdOrCreateWeak(object);
    }

    private static class LockFreeHashMap {
        private volatile TableAccessFlag accessFlag;
        private static final long accessFlagOffset = Unsafe.getUnsafe().objectFieldOffset(LockFreeHashMap.class, "accessFlag");
        private final ReferenceQueue<Object> refQueue = new ReferenceQueue();
        private volatile Thread refQueueThread;
        private volatile long lastId;
        private static final long lastIdOffset = Unsafe.getUnsafe().objectFieldOffset(LockFreeHashMap.class, "lastId");

        LockFreeHashMap() {
        }

        long getNextId() {
            long witnessId;
            long id = this.lastId;
            while ((witnessId = Unsafe.getUnsafe().compareAndExchangeLong(this, lastIdOffset, id, id + 1L)) != id) {
                id = witnessId;
            }
            return id + 1L;
        }

        private Thread startCleanupThread() {
            Thread queueThread = Thread.ofPlatform().name("JDWP Object map cleanup queue").unstarted(() -> {
                try {
                    while (true) {
                        Reference<Object> ref = this.refQueue.remove();
                        HashNodeWeak node = (HashNodeWeak)ref;
                        this.dispose(node);
                    }
                }
                catch (InterruptedException ex) {
                    return;
                }
            });
            if (ImageSingletons.contains(ThreadStartDeathSupport.class)) {
                ThreadStartDeathSupport.get().setDebuggerThreadObjectQueue(queueThread);
            }
            queueThread.setDaemon(true);
            queueThread.start();
            return queueThread;
        }

        void reset() {
            Thread queueThread = this.refQueueThread;
            if (queueThread != null) {
                queueThread.interrupt();
                if (ImageSingletons.contains(ThreadStartDeathSupport.class)) {
                    ThreadStartDeathSupport.get().setDebuggerThreadObjectQueue(null);
                }
            }
            if (queueThread != null) {
                try {
                    queueThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private TableAccessFlag getTableAccess() {
            TableAccessFlag flag = this.accessFlag;
            if (flag == null) {
                HashingTable table = new HashingTable(1024, null);
                flag = new TableAccessFlag(0, table);
                TableAccessFlag oldFlag = (TableAccessFlag)Unsafe.getUnsafe().compareAndExchangeReference(this, accessFlagOffset, null, flag);
                if (oldFlag == null) {
                    this.refQueueThread = this.startCleanupThread();
                } else {
                    flag = oldFlag;
                }
            }
            return flag;
        }

        private boolean setNewTableAccess(TableAccessFlag oldFlag, TableAccessFlag newFlag) {
            return Unsafe.getUnsafe().compareAndSetReference(this, accessFlagOffset, oldFlag, newFlag);
        }

        public long getIdExisting(Object obj) {
            int hash;
            if (obj == null) {
                return 0L;
            }
            TableAccessFlag flag = this.accessFlag;
            if (flag == null) {
                return -1L;
            }
            HashingTable table = flag.table();
            HashNode node = LockFreeHashMap.getIdExisting(table, obj, hash = System.identityHashCode(obj));
            if (node != null) {
                return node.getId();
            }
            return -1L;
        }

        private static HashNode getIdExisting(HashingTable table, Object obj, int hash) {
            for (HashingTable t = table; t != null; t = t.getNext()) {
                HashNode node = t.getIdExisting(obj, hash);
                if (node == null) continue;
                return node;
            }
            return null;
        }

        public long getIdOrCreateWeak(Object obj) {
            long id = this.getIdExisting(obj);
            if (id != -1L) {
                return id;
            }
            int hash = System.identityHashCode(obj);
            HashNode node = null;
            boolean[] needsFinalizeId = new boolean[]{false};
            do {
                TableAccessFlag tableAccess;
                HashingTable table;
                boolean needsResize;
                if (needsResize = (table = (tableAccess = this.getTableAccess()).table()).needsResize()) {
                    int hashTableLength = table.hashToObjectTable.length;
                    if (tableAccess.resizeCount % (hashTableLength / 16) == 0) {
                        int newSize = table.hashToObjectTable.length << 1;
                        HashingTable newTable = new HashingTable(newSize, table);
                        TableAccessFlag newTableAccess = new TableAccessFlag(0, newTable);
                        if (!this.setNewTableAccess(tableAccess, newTableAccess)) continue;
                        table = newTable;
                        tableAccess = newTableAccess;
                    } else {
                        TableAccessFlag newTableAccess = new TableAccessFlag(this.accessFlag.resizeCount + 1, table);
                        if (!this.setNewTableAccess(tableAccess, newTableAccess)) continue;
                    }
                }
                node = table.getIdOrCreateWeak(obj, hash, needsFinalizeId);
                if (needsFinalizeId[0]) {
                    if (tableAccess.table != this.accessFlag.table) continue;
                    node.finalizeId(this, table);
                }
                assert (node != null);
            } while (node == null || node.getId() < 0L);
            return node.getId();
        }

        public Object getObject(long id) {
            if (id == 0L) {
                return null;
            }
            TableAccessFlag flag = this.accessFlag;
            if (flag == null) {
                return null;
            }
            for (HashingTable table = flag.table(); table != null; table = table.getNext()) {
                Object obj = table.getObject(id);
                if (obj == null) continue;
                return obj;
            }
            return null;
        }

        private void dispose(HashNode node) {
            TableAccessFlag flag = this.accessFlag;
            if (flag == null) {
                return;
            }
            LockFreeHashMap.disposeAll(flag.table(), node);
        }

        private static void disposeAll(HashingTable table, HashNode node) {
            for (HashingTable t = table; t != null; t = t.getNext()) {
                t.dispose(node);
            }
        }

        boolean enableCollection(long id, int refCount, boolean disposeIfNotHold) {
            if (refCount < 0) {
                throw new IllegalArgumentException("Negative refCount not permitted: " + refCount);
            }
            TableAccessFlag flag = this.accessFlag;
            if (flag == null) {
                return false;
            }
            for (HashingTable table = flag.table(); table != null; table = table.getNext()) {
                boolean sucess = table.enableCollection(id, refCount, disposeIfNotHold);
                if (!sucess) continue;
                return sucess;
            }
            return false;
        }

        public boolean disableCollection(long id) {
            TableAccessFlag flag = this.accessFlag;
            if (flag == null) {
                return false;
            }
            for (HashingTable table = flag.table(); table != null; table = table.getNext()) {
                boolean sucess = table.disableCollection(id);
                if (!sucess) continue;
                return sucess;
            }
            return false;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Intentional.")
        public Boolean isCollected(long id) {
            if (id <= 0L || id > this.lastId) {
                return null;
            }
            Object obj = this.getObject(id);
            return null == obj;
        }

        private record TableAccessFlag(int resizeCount, HashingTable table) {
        }

        final class HashingTable {
            private final HashNode[][] hashToObjectTable;
            private final HashListNode[] idToHashTable;
            private final HashingTable next;
            private volatile int size;
            private static final long sizeOffset = Unsafe.getUnsafe().objectFieldOffset(HashingTable.class, "size");

            HashingTable(int size, HashingTable next) {
                this.idToHashTable = new HashListNode[size];
                this.hashToObjectTable = new HashNode[size][];
                this.next = next;
            }

            HashingTable getNext() {
                return this.next;
            }

            HashNode getIdExisting(Object obj, int hash) {
                int index = this.hashToObjectTable.length - 1 & hash;
                HashNode[] chain = (HashNode[])ObjectIdMap.getElementVolatile(this.hashToObjectTable, index);
                if (chain != null) {
                    for (HashNode node : chain) {
                        if (obj != node.getObject()) continue;
                        return node;
                    }
                }
                return null;
            }

            private void incrementSize() {
                this.changeSize(1);
            }

            private void decrementSize() {
                this.changeSize(-1);
            }

            private void changeSize(int increment) {
                int s;
                int oldSize = this.size;
                while ((s = Unsafe.getUnsafe().compareAndExchangeInt(this, sizeOffset, oldSize, oldSize + increment)) != oldSize) {
                    oldSize = s;
                }
            }

            boolean needsResize() {
                return this.size > this.hashToObjectTable.length && this.hashToObjectTable.length << 1 > 0;
            }

            private HashNode getIdOrCreateWeak(Object obj, int hash, boolean[] needsFinalizeId) {
                HashNode[] newChain;
                HashNode[] oldChain;
                int index = this.hashToObjectTable.length - 1 & hash;
                do {
                    if ((oldChain = (HashNode[])ObjectIdMap.getElementVolatile(this.hashToObjectTable, index)) != null) {
                        for (HashNode node : oldChain) {
                            if (node.getObject() != obj) continue;
                            needsFinalizeId[0] = false;
                            return node;
                        }
                        newChain = new HashNode[oldChain.length + 1];
                        System.arraycopy(oldChain, 0, newChain, 1, oldChain.length);
                        continue;
                    }
                    newChain = new HashNode[]{new HashNodeWeak(hash, obj, LockFreeHashMap.this.refQueue)};
                } while (!ObjectIdMap.compareAndSetElement((Object[])this.hashToObjectTable, index, oldChain, newChain));
                this.incrementSize();
                needsFinalizeId[0] = true;
                return newChain[0];
            }

            void newId(HashNode node) {
                HashListNode newList;
                HashListNode oldList;
                long newId = node.getId();
                int hash = node.getHash();
                int hashIndex = (int)((long)(this.idToHashTable.length - 1) & newId);
                while (!ObjectIdMap.compareAndSetElement(this.idToHashTable, hashIndex, oldList = ObjectIdMap.getElementVolatile(this.idToHashTable, hashIndex), newList = new HashListNode(hash, oldList))) {
                }
            }

            public Object getObject(long id) {
                if (id == 0L) {
                    return null;
                }
                int hashIndex = (int)((long)(this.idToHashTable.length - 1) & id);
                for (HashListNode list = ObjectIdMap.getElementVolatile(this.idToHashTable, hashIndex); list != null; list = list.next()) {
                    int hash = list.hash();
                    int index = this.hashToObjectTable.length - 1 & hash;
                    HashNode[] chain = (HashNode[])ObjectIdMap.getElementVolatile(this.hashToObjectTable, index);
                    if (chain == null) continue;
                    for (HashNode node : chain) {
                        if (id != node.getId()) continue;
                        return node.getObject();
                    }
                }
                return null;
            }

            private void dispose(HashNode node) {
                HashNode[] oldChain;
                long id = node.getId();
                int hash = node.getHash();
                int index = this.hashToObjectTable.length - 1 & hash;
                block0: while ((oldChain = (HashNode[])ObjectIdMap.getElementVolatile(this.hashToObjectTable, index)) != null) {
                    for (int i = 0; i < oldChain.length; ++i) {
                        if (oldChain[i].getId() != id) continue;
                        HashNode[] newChain = oldChain.length == 1 ? null : HashingTable.removeNode(oldChain, i);
                        if (!ObjectIdMap.compareAndSetElement((Object[])this.hashToObjectTable, index, oldChain, newChain)) continue block0;
                        this.disposeId(id, hash);
                        this.decrementSize();
                        break block0;
                    }
                }
            }

            private static HashNode[] removeNode(HashNode[] oldChain, int index) {
                HashNode[] newChain = new HashNode[oldChain.length - 1];
                if (index > 0) {
                    System.arraycopy(oldChain, 0, newChain, 0, index);
                }
                if (index < oldChain.length) {
                    System.arraycopy(oldChain, index + 1, newChain, index, newChain.length - index);
                }
                return newChain;
            }

            private static HashNode[] replaceNode(HashNode[] oldChain, int index, HashNode newNode) {
                if (oldChain.length == 1) {
                    return new HashNode[]{newNode};
                }
                HashNode[] newChain = new HashNode[oldChain.length];
                System.arraycopy(oldChain, 0, newChain, 0, oldChain.length);
                newChain[index] = newNode;
                return newChain;
            }

            private void disposeId(long id, int hash) {
                int hashIndex = (int)((long)(this.idToHashTable.length - 1) & id);
                block0: while (true) {
                    HashListNode oldList = ObjectIdMap.getElementVolatile(this.idToHashTable, hashIndex);
                    HashListNode nPrev = null;
                    for (HashListNode n = oldList; n != null; n = n.next()) {
                        if (n.hash() == hash) {
                            HashListNode newList;
                            if (nPrev == null) {
                                newList = n.next();
                            } else {
                                HashListNode end = n.next();
                                while (nPrev != null) {
                                    HashListNode nn;
                                    end = nn = new HashListNode(nPrev.hash(), end);
                                    HashListNode lastPrev = nPrev;
                                    nPrev = null;
                                    for (HashListNode on = oldList; on != lastPrev; on = on.next()) {
                                        nPrev = on;
                                    }
                                }
                                newList = end;
                            }
                            if (!ObjectIdMap.compareAndSetElement(this.idToHashTable, hashIndex, oldList, newList)) continue block0;
                            return;
                        }
                        nPrev = n;
                    }
                    break;
                }
            }

            boolean enableCollection(long id, int refCount, boolean disposeIfNotHold) {
                int hashIndex = (int)((long)(this.idToHashTable.length - 1) & id);
                for (HashListNode list = ObjectIdMap.getElementVolatile(this.idToHashTable, hashIndex); list != null; list = list.next()) {
                    HashNode[] chain;
                    int index = this.hashToObjectTable.length - 1 & list.hash();
                    block1: while ((chain = (HashNode[])ObjectIdMap.getElementVolatile(this.hashToObjectTable, index)) != null) {
                        for (int i = 0; i < chain.length; ++i) {
                            HashNode node = chain[i];
                            if (id != node.getId()) continue;
                            if (node instanceof HashNodeStrong) {
                                HashNodeStrong strongNode = (HashNodeStrong)node;
                                int holdCount = strongNode.changeHoldCount(-refCount);
                                if (holdCount == 0 || holdCount == Integer.MIN_VALUE) {
                                    if (disposeIfNotHold) {
                                        LockFreeHashMap.disposeAll(this, node);
                                    } else {
                                        HashNodeWeak weak = new HashNodeWeak(node.getHash(), node.getObject(), LockFreeHashMap.this.refQueue, node.getId());
                                        HashNode[] newChain = HashingTable.replaceNode(chain, i, weak);
                                        if (!ObjectIdMap.compareAndSetElement((Object[])this.hashToObjectTable, index, chain, newChain)) continue block1;
                                        if (this.next != null) {
                                            LockFreeHashMap.disposeAll(this.next, node);
                                        }
                                    }
                                }
                            } else if (disposeIfNotHold) {
                                LockFreeHashMap.disposeAll(this, node);
                            }
                            return true;
                        }
                    }
                }
                return false;
            }

            public boolean disableCollection(long id) {
                int hashIndex = (int)((long)(this.idToHashTable.length - 1) & id);
                for (HashListNode list = ObjectIdMap.getElementVolatile(this.idToHashTable, hashIndex); list != null; list = list.next()) {
                    HashNode[] chain;
                    int index = this.hashToObjectTable.length - 1 & list.hash();
                    block1: while ((chain = (HashNode[])ObjectIdMap.getElementVolatile(this.hashToObjectTable, index)) != null) {
                        for (int i = 0; i < chain.length; ++i) {
                            HashNode node = chain[i];
                            if (id != node.getId()) continue;
                            if (node instanceof HashNodeStrong) {
                                HashNodeStrong strongNode = (HashNodeStrong)node;
                                strongNode.changeHoldCount(1);
                            } else {
                                Object obj = node.getObject();
                                if (obj == null) {
                                    return false;
                                }
                                HashNodeStrong strong = new HashNodeStrong(node.getHash(), obj, node.getId());
                                HashNode[] newChain = HashingTable.replaceNode(chain, i, strong);
                                if (!ObjectIdMap.compareAndSetElement((Object[])this.hashToObjectTable, index, chain, newChain)) continue block1;
                                if (this.next != null) {
                                    LockFreeHashMap.disposeAll(this.next, node);
                                }
                            }
                            return true;
                        }
                    }
                }
                return false;
            }
        }
    }

    private record HashListNode(int hash, HashListNode next) {
    }

    private static final class HashNodeStrong
    implements HashNode {
        private final long id;
        private final int hash;
        private final Object object;
        private volatile int holdCount = 1;
        private static final long holdCountOffset = Unsafe.getUnsafe().objectFieldOffset(HashNodeStrong.class, "holdCount");

        HashNodeStrong(int hash, Object object, long id) {
            this.id = id;
            this.hash = hash;
            this.object = object;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public long finalizeId(LockFreeHashMap map, LockFreeHashMap.HashingTable table) {
            throw new UnsupportedOperationException();
        }

        int changeHoldCount(int increment) {
            int newCount;
            int oldCount = this.holdCount;
            if (oldCount == 0) {
                return Integer.MIN_VALUE;
            }
            while (true) {
                int count;
                if ((newCount = oldCount + increment) < 0) {
                    newCount = 0;
                }
                if ((count = Unsafe.getUnsafe().compareAndExchangeInt(this, holdCountOffset, oldCount, newCount)) == oldCount) break;
                oldCount = count;
            }
            return newCount;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public Object getObject() {
            return this.object;
        }
    }

    private static final class HashNodeWeak
    extends WeakReference<Object>
    implements HashNode {
        private volatile long id;
        private final int hash;

        HashNodeWeak(int hash, Object referent, ReferenceQueue<Object> refQueue) {
            this(hash, referent, refQueue, -1L);
        }

        HashNodeWeak(int hash, Object referent, ReferenceQueue<Object> refQueue, long id) {
            super(referent, refQueue);
            this.id = id;
            this.hash = hash;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public long finalizeId(LockFreeHashMap map, LockFreeHashMap.HashingTable table) {
            long theId = this.id;
            if (theId <= -1L) {
                this.id = theId = map.getNextId();
            }
            table.newId(this);
            return theId;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public Object getObject() {
            return this.get();
        }
    }

    private static sealed interface HashNode
    permits HashNodeWeak, HashNodeStrong {
        public long getId();

        public long finalizeId(LockFreeHashMap var1, LockFreeHashMap.HashingTable var2);

        public int getHash();

        public Object getObject();
    }
}

