/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public abstract class AccessFieldTypeFlow
extends TypeFlow<BytecodePosition> {
    protected final AnalysisField field;

    protected AccessFieldTypeFlow(BytecodePosition accessLocation, AnalysisField field) {
        super(accessLocation, AccessFieldTypeFlow.filterUncheckedInterface(field.getType()));
        this.field = field;
    }

    protected AccessFieldTypeFlow(AccessFieldTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows);
        this.field = original.field;
    }

    public AnalysisField field() {
        return this.field;
    }

    protected TypeState filterObjectState(PointsToAnalysis bb, TypeState objectState) {
        if (bb.analysisPolicy().relaxTypeFlowConstraints()) {
            return TypeState.forIntersection(bb, objectState, this.field.getDeclaringClass().getAssignableTypes(true));
        }
        return objectState;
    }
}

