/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.GlobalFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.typestate.TypeState;

public class FieldFilterTypeFlow
extends TypeFlow<AnalysisField>
implements GlobalFlow {
    public FieldFilterTypeFlow(AnalysisField field) {
        super(field, field.getType());
    }

    @Override
    protected TypeState processInputState(PointsToAnalysis bb, TypeState update) {
        if (this.isPrimitiveFlow) {
            if (!update.isPrimitive()) {
                return TypeState.anyPrimitiveState();
            }
            return update;
        }
        if (this.declaredType.equals(bb.getObjectType())) {
            return update;
        }
        return TypeState.forIntersection(bb, update, this.declaredType.getAssignableTypes(true));
    }

    @Override
    public void addPredicated(PointsToAnalysis bb, TypeFlow<?> predicatedFlow) {
        if (this.isSaturated()) {
            this.declaredType.getTypeFlow(bb, true).addPredicated(bb, predicatedFlow);
            return;
        }
        super.addPredicated(bb, predicatedFlow);
    }

    @Override
    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        if (bb.isClosed(this.declaredType)) {
            if (!this.setSaturated()) {
                return;
            }
            this.swapOut(bb, this.declaredType.getTypeFlow(bb, true));
        } else {
            super.onInputSaturated(bb, input);
        }
    }

    @Override
    protected void notifyUseOfSaturation(PointsToAnalysis bb, TypeFlow<?> use) {
        if (bb.isClosed(this.declaredType)) {
            this.swapAtUse(bb, this.declaredType.getTypeFlow(bb, true), use);
        } else {
            super.notifyUseOfSaturation(bb, use);
        }
    }

    @Override
    protected void notifyObserverOfSaturation(PointsToAnalysis bb, TypeFlow<?> observer) {
        if (bb.isClosed(this.declaredType)) {
            this.swapAtObserver(bb, this.declaredType.getTypeFlow(bb, true), observer);
        } else {
            super.notifyObserverOfSaturation(bb, observer);
        }
    }

    @Override
    public String toString() {
        return "FieldFilterTypeFlow<" + String.valueOf(this.source) + ">";
    }
}

