/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import jdk.vm.ci.meta.JavaConstant;

public final class TypeData {
    private static final VarHandle arrayHandle = MethodHandles.arrayElementVarHandle(Object[].class);
    private final Object[] values;

    public TypeData(int length) {
        this.values = new Object[length];
    }

    public void setFieldTask(AnalysisField field, AnalysisFuture<JavaConstant> task) {
        arrayHandle.setVolatile(this.values, field.getPosition(), task);
    }

    public void setFieldValue(AnalysisField field, JavaConstant value) {
        arrayHandle.setVolatile(this.values, field.getPosition(), value);
    }

    public Object getFieldValue(AnalysisField field) {
        return arrayHandle.getVolatile(this.values, field.getPosition());
    }

    public JavaConstant readFieldValue(AnalysisField field) {
        Object value = this.getFieldValue(field);
        return value instanceof JavaConstant ? (JavaConstant)value : (JavaConstant)((AnalysisFuture)value).ensureDone();
    }
}

