/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import com.oracle.graal.pointsto.meta.BaseLayerMethod;
import com.oracle.graal.pointsto.util.GraalAccess;
import java.lang.reflect.Executable;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public interface OriginalMethodProvider {
    public static ResolvedJavaMethod getOriginalMethod(ResolvedJavaMethod method) {
        ResolvedJavaMethod cur = method;
        while (cur instanceof OriginalMethodProvider) {
            OriginalMethodProvider originalMethodProvider = (OriginalMethodProvider)cur;
            cur = originalMethodProvider.unwrapTowardsOriginalMethod();
        }
        return cur;
    }

    public static Executable getJavaMethod(ResolvedJavaMethod method) {
        ResolvedJavaMethod originalMethod = OriginalMethodProvider.getOriginalMethod(method);
        if (originalMethod instanceof BaseLayerMethod) {
            return null;
        }
        if (originalMethod != null) {
            try {
                return GraalAccess.getOriginalSnippetReflection().originalMethod(originalMethod);
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
        return null;
    }

    public ResolvedJavaMethod unwrapTowardsOriginalMethod();
}

