/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.bytecode;

import com.oracle.svm.espresso.classfile.bytecode.BytecodeLookupSwitch;
import com.oracle.svm.espresso.classfile.bytecode.BytecodeTableSwitch;
import com.oracle.svm.espresso.classfile.bytecode.Bytecodes;
import com.oracle.svm.espresso.classfile.bytecode.Bytes;

public final class BytecodeStream {
    private final byte[] code;

    public BytecodeStream(byte[] code) {
        assert (code != null);
        this.code = code;
    }

    public int nextBCI(int curBCI) {
        return curBCI + this.lengthOf(curBCI);
    }

    public int endBCI() {
        return this.code.length;
    }

    public int currentBC(int curBCI) {
        int opcode = this.opcode(curBCI);
        if (opcode == 196) {
            return Bytes.beU1(this.code, curBCI + 1);
        }
        return opcode;
    }

    public int currentVolatileBC(int curBCI) {
        int opcode = this.volatileOpcode(curBCI);
        if (opcode == 196) {
            return Bytes.volatileBeU1(this.code, curBCI + 1);
        }
        return opcode;
    }

    public int readLocalIndex(int curBCI) {
        if (this.opcode(curBCI) == 196) {
            return Bytes.beU2(this.code, curBCI + 2);
        }
        return Bytes.beU1(this.code, curBCI + 1);
    }

    public int readLocalIndex1(int curBCI) {
        return Bytes.beU1(this.code, curBCI + 1);
    }

    public int readLocalIndex2(int curBCI) {
        return Bytes.beU2(this.code, curBCI + 2);
    }

    public int readIncrement(int curBCI) {
        if (this.opcode(curBCI) == 196) {
            return Bytes.beS2(this.code, curBCI + 4);
        }
        return Bytes.beS1(this.code, curBCI + 2);
    }

    public int readIncrement1(int curBCI) {
        return Bytes.beS1(this.code, curBCI + 2);
    }

    public int readIncrement2(int curBCI) {
        return Bytes.beS2(this.code, curBCI + 4);
    }

    public int readBranchDest(int curBCI) {
        int opcode = this.opcode(curBCI);
        if (opcode == 200 || opcode == 201) {
            return curBCI + Bytes.beS4(this.code, curBCI + 1);
        }
        return curBCI + Bytes.beS2(this.code, curBCI + 1);
    }

    public int readBranchDest4(int curBCI) {
        return curBCI + Bytes.beS4(this.code, curBCI + 1);
    }

    public int readBranchDest2(int curBCI) {
        return curBCI + Bytes.beS2(this.code, curBCI + 1);
    }

    public int readInt(int bci) {
        return Bytes.beS4(this.code, bci);
    }

    public int readUByte(int bci) {
        return Bytes.beU1(this.code, bci);
    }

    public char readCPI(int curBCI) {
        if (this.opcode(curBCI) == 18) {
            return (char)Bytes.beU1(this.code, curBCI + 1);
        }
        return (char)Bytes.beU2(this.code, curBCI + 1);
    }

    public char readCPI1(int curBCI) {
        return (char)Bytes.beU1(this.code, curBCI + 1);
    }

    public char readCPI2(int curBCI) {
        return (char)Bytes.beU2(this.code, curBCI + 1);
    }

    public static char readCPI(byte[] code, int curBCI) {
        if (BytecodeStream.opcode(code, curBCI) == 18) {
            return (char)Bytes.beU1(code, curBCI + 1);
        }
        return (char)Bytes.beU2(code, curBCI + 1);
    }

    public int readCPI4(int curBCI) {
        assert (this.opcode(curBCI) == 186);
        return Bytes.beS4(this.code, curBCI + 1);
    }

    public void writeCPI4(int curBCI, int value) {
        assert (this.opcode(curBCI) == 186);
        Bytes.beS4(this.code, curBCI + 1, value);
    }

    public byte readByte(int curBCI) {
        return this.code[curBCI + 1];
    }

    public short readShort(int curBCI) {
        return (short)Bytes.beS2(this.code, curBCI + 1);
    }

    public int opcode(int curBCI) {
        return Bytes.beU1(this.code, curBCI);
    }

    private static int opcode(byte[] code, int curBCI) {
        return Bytes.beU1(code, curBCI);
    }

    public int volatileOpcode(int curBCI) {
        return Bytes.volatileBeU1(this.code, curBCI);
    }

    private int lengthOf(int curBCI) {
        int opcode = this.opcode(curBCI);
        int length = Bytecodes.lengthOf(opcode);
        if (length == 0) {
            switch (opcode) {
                case 170: {
                    return BytecodeTableSwitch.INSTANCE.size(this, curBCI);
                }
                case 171: {
                    return BytecodeLookupSwitch.INSTANCE.size(this, curBCI);
                }
                case 196: {
                    int opc = Bytes.beU1(this.code, curBCI + 1);
                    if (opc == 132) {
                        return 6;
                    }
                    return 4;
                }
            }
            throw new IllegalStateException(BytecodeStream.unknownVariableLengthBytecodeMessage(opcode));
        }
        return length;
    }

    private static String unknownVariableLengthBytecodeMessage(int opcode) {
        return "unknown variable-length bytecode: " + Bytecodes.nameOf(opcode);
    }
}

