/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

final class SubroutineModificationStack {
    SubroutineModificationStack next;
    boolean[] subRoutineModifications;
    int jsrBCI;
    int depth;

    SubroutineModificationStack(SubroutineModificationStack next, boolean[] subRoutineModifications, int bci) {
        this.next = next;
        this.depth = next == null ? 1 : 1 + next.depth();
        this.subRoutineModifications = subRoutineModifications;
        this.jsrBCI = bci;
    }

    static SubroutineModificationStack copy(SubroutineModificationStack tocopy) {
        if (tocopy == null) {
            return null;
        }
        return new SubroutineModificationStack(tocopy.next, (boolean[])tocopy.subRoutineModifications.clone(), tocopy.jsrBCI);
    }

    public void merge(SubroutineModificationStack other) {
        assert (other.subRoutineModifications.length == this.subRoutineModifications.length);
        for (int i = 0; i < this.subRoutineModifications.length; ++i) {
            if (!other.subRoutineModifications[i] || this.subRoutineModifications[i]) continue;
            this.subRoutineModifications[i] = true;
        }
    }

    public int depth() {
        return this.depth;
    }
}

