/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server;

import com.oracle.svm.jdwp.bridge.DebugOptions;
import com.oracle.svm.jdwp.bridge.Packet;
import com.oracle.svm.jdwp.server.api.ConnectionController;
import com.oracle.svm.jdwp.server.impl.DebuggerConnection;
import com.oracle.svm.jdwp.server.impl.DebuggerController;
import com.oracle.svm.jdwp.server.impl.HandshakeController;
import com.oracle.svm.jdwp.server.impl.SocketConnection;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;

public final class JDWPHandler
implements Runnable {
    static final String HOST = "*";
    static final int PORT = 8000;
    private final ConnectionControllerImpl connectionController;
    private volatile DebuggerController debuggerController;

    JDWPHandler(long initialThreadId) {
        this.connectionController = new ConnectionControllerImpl(initialThreadId);
    }

    public DebuggerController getController() {
        return this.debuggerController;
    }

    void doConnect(DebugOptions.Options options) {
        this.connectionController.doConnect(options);
    }

    @Override
    public void run() {
        DebugOptions.Options dummyOptions = DebugOptions.parse((String)"transport=dt_socket,server=y,suspend=n,address=*:8000", (boolean)false);
        this.doConnect(dummyOptions);
    }

    private static void handleConnectException(ConnectException ex) {
        System.err.println("ERROR: transport error 202: connect failed: " + ex.getMessage());
        System.err.println("ERROR: JDWP Transport dt_socket failed to initialize, TRANSPORT_INIT(510)");
        System.err.println("JDWP exit error AGENT_ERROR_TRANSPORT_INIT(197): No transports initialized");
    }

    private final class ConnectionControllerImpl
    implements ConnectionController {
        private long initialThreadId;
        private DebugOptions.Options lastOptions;
        private volatile DebuggerConnection lastConnection;

        private ConnectionControllerImpl(long initialThreadId) {
            this.initialThreadId = initialThreadId;
        }

        @Override
        public void dispose(Packet replyPacket) {
            DebuggerConnection connection = this.lastConnection;
            this.lastConnection = null;
            if (connection != null) {
                connection.queuePacket(replyPacket);
                connection.close();
            }
        }

        @Override
        public void restart() {
            if (this.lastOptions != null && this.lastOptions.server()) {
                this.doConnect(this.lastOptions);
            }
        }

        void doConnect(DebugOptions.Options options) {
            DebuggerController controller;
            SocketConnection socketConnection;
            this.lastOptions = options;
            ArrayList<Thread> activeThreads = new ArrayList<Thread>();
            try (HandshakeController hsController = new HandshakeController(options);){
                socketConnection = hsController.createSocketConnection(activeThreads);
            }
            catch (ConnectException ex) {
                JDWPHandler.handleConnectException(ex);
                return;
            }
            catch (IOException ioex) {
                System.err.println("Critical failure in establishing JDWP connection: " + ioex.getLocalizedMessage());
                return;
            }
            JDWPHandler.this.debuggerController = controller = new DebuggerController(this.initialThreadId, JDWPHandler.this.connectionController);
            DebuggerConnection connection = new DebuggerConnection(socketConnection, controller, activeThreads);
            controller.getEventListener().setConnection(socketConnection);
            Runnable vmStartedJob = () -> controller.getEventListener().vmStarted(options.suspend());
            this.lastConnection = connection;
            connection.doProcessCommands(options.suspend(), vmStartedJob);
            this.initialThreadId = 0L;
        }
    }
}

